<?php
// api/address_suggest.php
header('Content-Type: application/json');

$config = require __DIR__ . '/config.php';
$openai = $config['openai'];

$q = isset($_GET['q']) ? trim($_GET['q']) : '';
if ($q === '') {
    echo json_encode(['suggestions' => []]);
    exit;
}

if (empty($openai['enabled']) || empty($openai['api_key'])) {
    // Fallback: simple echo of the query
    echo json_encode(['suggestions' => [$q]]);
    exit;
}

// Build a simple prompt to normalize US street addresses
$prompt = 'User typed: "' . $q . "".
"
    . "Return up to 5 likely full US street addresses (street, city, state, zip) in a JSON array of strings.
"
    . "Example: ["123 Main St, Dallas, TX 75201", "123 Main Street, Dallas, TX 75201"].
"
    . "Only output the JSON array, nothing else.";

$body = [
    'model' => $openai['model'],
    'messages' => [
        ['role' => 'system', 'content' => 'You normalize partial US street addresses.'],
        ['role' => 'user', 'content' => $prompt],
    ],
    'temperature' => 0.2,
];

$ch = curl_init('https://api.openai.com/v1/chat/completions');
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $openai['api_key'],
    ],
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($body),
    CURLOPT_TIMEOUT => 15,
]);

$resp = curl_exec($ch);
if ($resp === false) {
    curl_close($ch);
    echo json_encode(['suggestions' => [$q]]);
    exit;
}
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($code < 200 || $code >= 300) {
    echo json_encode(['suggestions' => [$q]]);
    exit;
}

$data = json_decode($resp, true);
$suggestions = [];
if (isset($data['choices'][0]['message']['content'])) {
    $content = trim($data['choices'][0]['message']['content']);
    $arr = json_decode($content, true);
    if (is_array($arr)) {
        $suggestions = $arr;
    }
}

if (!$suggestions) {
    $suggestions = [$q];
}

echo json_encode(['suggestions' => $suggestions]);
