<?php
// property.php
// Single controller for all property tabs (description, analysis, etc.)
// Right now, the "description" tab is fully implemented.
// You can expand other tabs in the same file later.

// Get query params
$propertyId = isset($_GET['id']) ? $_GET['id'] : null;
$tab = isset($_GET['tab']) ? $_GET['tab'] : 'description'; // default to description
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <title>MLS9 - Property</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />

  <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400italic,600" />
  <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" />
  <link rel="stylesheet"
        href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css" />

  <!-- Use your existing CSS -->
  <link rel="stylesheet" href="css/style.css" />
</head>
<body>
<div class="wrapper">

  <?php include __DIR__ . '/includes/header_nav.php'; ?>

  <main class="main-content" id="main-content">
    <div class="content-wrapper">

      <div class="sidebar-float sidebar-property">

        <?php
        // Sidebar with all property menu items (Description, Worksheet, etc.)
        // Make sure sidebar links point to: property.php?id=...&tab=...
        include __DIR__ . '/includes/sidebar_property.php';
        ?>

        <!-- MAIN CONTENT AREA -->
        <section class="content-with-sidebar">

          <?php if (!$propertyId): ?>
            <h2 class="content-heading margin-b-20">Property Not Found</h2>
            <div class="help-block">Missing <code>?id=</code> in URL.</div>

          <?php else: ?>

            <?php if ($tab === 'description'): ?>

              <!-- =========================
                   PROPERTY DESCRIPTION TAB
                   ========================= -->
              <h2 class="content-heading margin-b-20">
                Property Description
                <div class="pull-right">
                  <button id="save-description"
                          class="btn btn-primary btn-outline btn-sm btn-icon">
                    <i class="icon ion-checkmark"></i> Save
                  </button>
                </div>
                <ul class="breadcrumb">
                  <li><a href="index.php" class="link blue">Rentals</a></li>
                  <li><a href="#" id="breadcrumb-address" class="link blue">Property</a></li>
                  <li class="active"><span>Property Description</span></li>
                </ul>
              </h2>

              <div class="help-block margin-b-35">
                Edit the basic information, physical characteristics and location details of this property.
              </div>

              <!-- BASIC INFORMATION -->
              <div class="panel panel-default">
                <div class="panel-heading">
                  <h4 class="panel-title">Basic Information</h4>
                </div>

                <div class="panel-body">
                  <fieldset>

                    <div class="row">
                      <div class="col-sm-6">
                        <label>Property Type</label>
                        <select id="property_type" class="form-control">
                          <option value="">Select...</option>
                          <option value="single_family">Single Family</option>
                          <option value="multi_family">Multi-Family</option>
                          <option value="condo">Condo</option>
                          <option value="townhouse">Townhouse</option>
                          <option value="apartment">Apartment</option>
                          <option value="mobile_home">Mobile Home</option>
                          <option value="land">Land</option>
                          <option value="other">Other</option>
                        </select>
                      </div>

                      <div class="col-sm-6">
                        <label>Property Subtype</label>
                        <input id="property_subtype" type="text" class="form-control"
                               placeholder="Duplex, Triplex, 4-Plex, etc." />
                      </div>
                    </div>

                    <div class="row margin-t-15">
                      <div class="col-sm-3">
                        <label>Bedrooms</label>
                        <input id="beds" type="number" step="1" class="form-control" />
                      </div>

                      <div class="col-sm-3">
                        <label>Half Beds</label>
                        <input id="beds_half" type="number" step="1" class="form-control" />
                      </div>

                      <div class="col-sm-3">
                        <label>Bathrooms</label>
                        <input id="baths" type="number" step="0.1" class="form-control" />
                      </div>

                      <div class="col-sm-3">
                        <label>Half Baths</label>
                        <input id="baths_half" type="number" step="0.1" class="form-control" />
                      </div>
                    </div>

                    <div class="row margin-t-15">
                      <div class="col-sm-4">
                        <label>Living Area (Sq.Ft.)</label>
                        <input id="sqft" type="number" class="form-control" />
                      </div>

                      <div class="col-sm-4">
                        <label>Lot Size (Sq.Ft.)</label>
                        <input id="lot_size_sqft" type="number" class="form-control" />
                      </div>

                      <div class="col-sm-4">
                        <label>Lot Size (Acres)</label>
                        <input id="lot_size_acres" type="number" step="0.01" class="form-control" />
                      </div>
                    </div>

                    <div class="row margin-t-15">
                      <div class="col-sm-4">
                        <label>Year Built</label>
                        <input id="year_built" type="number" class="form-control" />
                      </div>

                      <div class="col-sm-4">
                        <label>Stories</label>
                        <input id="stories" type="number" class="form-control" />
                      </div>

                      <div class="col-sm-4">
                        <label>Building Class</label>
                        <input id="building_class" type="text" class="form-control"
                               placeholder="A, B, C, etc." />
                      </div>
                    </div>

                  </fieldset>
                </div>
              </div>

              <!-- FEATURES / STRUCTURE -->
              <div class="panel panel-default">
                <div class="panel-heading">
                  <h4 class="panel-title">Structure &amp; Features</h4>
                </div>

                <div class="panel-body">
                  <fieldset>

                    <div class="row">
                      <div class="col-sm-4">
                        <label>Parking Type</label>
                        <input id="parking" type="text" class="form-control"
                               placeholder="Garage, Carport, Driveway, etc." />
                      </div>

                      <div class="col-sm-4">
                        <label>Garage Spaces</label>
                        <input id="garage_spaces" type="number" class="form-control" />
                      </div>

                      <div class="col-sm-4">
                        <label>Covered Parking Spaces</label>
                        <input id="parking_covered" type="number" class="form-control" />
                      </div>
                    </div>

                    <div class="row margin-t-15">
                      <div class="col-sm-4">
                        <label>Exterior</label>
                        <input id="exterior_type" type="text" class="form-control"
                               placeholder="Brick, Siding, Stucco, etc." />
                      </div>

                      <div class="col-sm-4">
                        <label>Roof Type</label>
                        <input id="roof_type" type="text" class="form-control"
                               placeholder="Composition, Metal, Tile, etc." />
                      </div>

                      <div class="col-sm-4">
                        <label>Foundation</label>
                        <input id="foundation_type" type="text" class="form-control"
                               placeholder="Slab, Pier &amp; Beam, Basement, etc." />
                      </div>
                    </div>

                    <div class="row margin-t-15">
                      <div class="col-sm-4">
                        <label>Heating</label>
                        <input id="heating_type" type="text" class="form-control"
                               placeholder="Central, Electric, Gas, etc." />
                      </div>

                      <div class="col-sm-4">
                        <label>Cooling</label>
                        <input id="cooling_type" type="text" class="form-control"
                               placeholder="Central, Window Units, etc." />
                      </div>

                      <div class="col-sm-4">
                        <label>Basement Type</label>
                        <input id="basement_type" type="text" class="form-control"
                               placeholder="None, Finished, Unfinished, Partial, etc." />
                      </div>
                    </div>

                    <div class="row margin-t-15">
                      <div class="col-sm-3">
                        <label>
                          <input id="has_pool" type="checkbox" />
                          &nbsp; Has Pool
                        </label>
                      </div>

                      <div class="col-sm-3">
                        <label>
                          <input id="has_basement" type="checkbox" />
                          &nbsp; Has Basement
                        </label>
                      </div>

                      <div class="col-sm-3">
                        <label>
                          <input id="has_waterfront" type="checkbox" />
                          &nbsp; Waterfront
                        </label>
                      </div>

                      <div class="col-sm-3">
                        <label>
                          <input id="has_view" type="checkbox" />
                          &nbsp; Notable View
                        </label>
                      </div>
                    </div>

                    <div class="row margin-t-15">
                      <div class="col-sm-12">
                        <label>View Description</label>
                        <input id="view_description" type="text" class="form-control"
                               placeholder="City, Lake, Mountain, Greenbelt, etc." />
                      </div>
                    </div>

                  </fieldset>
                </div>
              </div>

              <!-- LOCATION & SCHOOLS -->
              <div class="panel panel-default">
                <div class="panel-heading">
                  <h4 class="panel-title">Location &amp; Schools</h4>
                </div>

                <div class="panel-body">
                  <fieldset>

                    <div class="row">
                      <div class="col-sm-6">
                        <label>County</label>
                        <input id="county" type="text" class="form-control" />
                      </div>

                      <div class="col-sm-6">
                        <label>Subdivision / Neighborhood</label>
                        <input id="subdivision" type="text" class="form-control" />
                      </div>
                    </div>

                    <div class="row margin-t-15">
                      <div class="col-sm-6">
                        <label>School District</label>
                        <input id="school_district" type="text" class="form-control" />
                      </div>
                      <div class="col-sm-6">
                        <label>APN / Parcel Number</label>
                        <input id="apn" type="text" class="form-control" />
                      </div>
                    </div>

                    <div class="row margin-t-15">
                      <div class="col-sm-4">
                        <label>Elementary School</label>
                        <input id="elementary_school" type="text" class="form-control" />
                      </div>
                      <div class="col-sm-4">
                        <label>Middle School</label>
                        <input id="middle_school" type="text" class="form-control" />
                      </div>
                      <div class="col-sm-4">
                        <label>High School</label>
                        <input id="high_school" type="text" class="form-control" />
                      </div>
                    </div>

                  </fieldset>
                </div>
              </div>

              <!-- DESCRIPTIONS / NOTES -->
              <div class="panel panel-default">
                <div class="panel-heading">
                  <h4 class="panel-title">Descriptions &amp; Notes</h4>
                </div>

                <div class="panel-body">
                  <fieldset>

                    <div class="row">
                      <div class="col-sm-12">
                        <label>Public Description</label>
                        <textarea id="description" class="form-control" rows="4"
                                  placeholder="Listing-style description of the property..."></textarea>
                      </div>
                    </div>

                    <div class="row margin-t-15">
                      <div class="col-sm-12">
                        <label>Private Notes (Internal)</label>
                        <textarea id="notes" class="form-control" rows="3"
                                  placeholder="Your internal notes and remarks..."></textarea>
                      </div>
                    </div>

                  </fieldset>
                </div>
              </div>

            <?php else: ?>

              <!-- =========================
                   PLACEHOLDER FOR OTHER TABS
                   ========================= -->
              <h2 class="content-heading margin-b-20">
                Coming Soon
                <ul class="breadcrumb">
                  <li><a href="index.php" class="link blue">Rentals</a></li>
                  <li><a href="#" id="breadcrumb-address" class="link blue">Property</a></li>
                  <li class="active"><span><?php echo htmlspecialchars(ucwords(str_replace('_', ' ', $tab))); ?></span></li>
                </ul>
              </h2>
              <div class="help-block">
                This tab (<code><?php echo htmlspecialchars($tab); ?></code>) will be implemented next in this same file.
              </div>

            <?php endif; ?>

          <?php endif; ?>

        </section>

      </div>

    </div>
  </main>

  <?php include __DIR__ . '/includes/footer.php'; ?>

</div>

<!-- INLINE JS ONLY (no extra JS files) -->
<script>
document.addEventListener("DOMContentLoaded", function () {
  const propertyId = "<?php echo htmlspecialchars($propertyId ?: '', ENT_QUOTES); ?>";
  const currentTab = "<?php echo htmlspecialchars($tab, ENT_QUOTES); ?>";

  if (!propertyId) return;

  // Only run the description logic on the description tab
  if (currentTab !== "description") return;

  // Load property JSON from backend
  fetch("api/property.php?action=get&id=" + encodeURIComponent(propertyId))
    .then(r => r.json())
    .then(data => {
      if (!data || data.error) {
        console.error("Property load error:", data);
        alert("Could not load property.");
        return;
      }
      loadDescriptionForm(data);
    })
    .catch(err => {
      console.error(err);
      alert("Error loading property.");
    });

  function loadDescriptionForm(p) {
    // Breadcrumb + sidebar values if elements exist
    if (p.full_address && document.getElementById("breadcrumb-address")) {
      document.getElementById("breadcrumb-address").innerText = p.full_address;
    }

    // BASIC
    setVal("property_type", p.property_type);
    setVal("property_subtype", p.property_subtype);
    setVal("beds", p.beds);
    setVal("beds_half", p.beds_half);
    setVal("baths", p.baths);
    setVal("baths_half", p.baths_half);
    setVal("sqft", p.sqft);
    setVal("lot_size_sqft", p.lot_size_sqft);
    setVal("lot_size_acres", p.lot_size_acres);
    setVal("year_built", p.year_built);
    setVal("stories", p.stories);
    setVal("building_class", p.building_class);

    // FEATURES
    setVal("parking", p.parking);
    setVal("garage_spaces", p.garage_spaces);
    setVal("parking_covered", p.parking_covered);
    setVal("exterior_type", p.exterior_type);
    setVal("roof_type", p.roof_type);
    setVal("foundation_type", p.foundation_type);
    setVal("heating_type", p.heating_type);
    setVal("cooling_type", p.cooling_type);
    setVal("basement_type", p.basement_type);

    setChecked("has_pool", !!p.has_pool);
    setChecked("has_basement", !!p.has_basement);
    setChecked("has_waterfront", !!p.has_waterfront);
    setChecked("has_view", !!p.has_view);
    setVal("view_description", p.view_description);

    // LOCATION
    setVal("county", p.county);
    setVal("subdivision", p.subdivision);
    setVal("school_district", p.school_district);
    setVal("apn", p.apn);
    setVal("elementary_school", p.elementary_school);
    setVal("middle_school", p.middle_school);
    setVal("high_school", p.high_school);

    // TEXT
    setVal("description", p.description);
    setVal("notes", p.notes);
  }

  function setVal(id, value) {
    const el = document.getElementById(id);
    if (!el) return;
    if (el.tagName === "SELECT" || el.tagName === "INPUT" || el.tagName === "TEXTAREA") {
      el.value = (value === null || value === undefined) ? "" : value;
    }
  }

  function setChecked(id, value) {
    const el = document.getElementById(id);
    if (!el) return;
    el.checked = !!value;
  }

  function getVal(id) {
    const el = document.getElementById(id);
    if (!el) return null;
    if (el.type === "checkbox") {
      return el.checked ? 1 : 0;
    }
    return el.value.trim();
  }

  // SAVE DESCRIPTION TAB
  const saveBtn = document.getElementById("save-description");
  if (saveBtn) {
    saveBtn.addEventListener("click", function () {
      const payload = {
        id: propertyId,
        fields: {
          // BASIC
          property_type: getVal("property_type"),
          property_subtype: getVal("property_subtype"),
          beds: getVal("beds"),
          beds_half: getVal("beds_half"),
          baths: getVal("baths"),
          baths_half: getVal("baths_half"),
          sqft: getVal("sqft"),
          lot_size_sqft: getVal("lot_size_sqft"),
          lot_size_acres: getVal("lot_size_acres"),
          year_built: getVal("year_built"),
          stories: getVal("stories"),
          building_class: getVal("building_class"),

          // FEATURES
          parking: getVal("parking"),
          garage_spaces: getVal("garage_spaces"),
          parking_covered: getVal("parking_covered"),
          exterior_type: getVal("exterior_type"),
          roof_type: getVal("roof_type"),
          foundation_type: getVal("foundation_type"),
          heating_type: getVal("heating_type"),
          cooling_type: getVal("cooling_type"),
          basement_type: getVal("basement_type"),
          has_pool: getVal("has_pool"),
          has_basement: getVal("has_basement"),
          has_waterfront: getVal("has_waterfront"),
          has_view: getVal("has_view"),
          view_description: getVal("view_description"),

          // LOCATION
          county: getVal("county"),
          subdivision: getVal("subdivision"),
          school_district: getVal("school_district"),
          apn: getVal("apn"),
          elementary_school: getVal("elementary_school"),
          middle_school: getVal("middle_school"),
          high_school: getVal("high_school"),

          // TEXT
          description: getVal("description"),
          notes: getVal("notes")
        }
      };

      fetch("api/property.php?action=update_field", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(payload)
      })
        .then(r => r.json())
        .then(res => {
          if (res && !res.error) {
            alert("Property description saved.");
          } else {
            console.error("Save error:", res);
            alert("Error saving property description.");
          }
        })
        .catch(err => {
          console.error(err);
          alert("Error saving property description.");
        });
    });
  }
});
</script>

</body>
</html>
