<?php
// /includes/sidebar_property.php
?>
<aside class="sidebar sidebar-content">

  <!-- Back button -->
  <div class="property-action-buttons-top">
    <a href="index.php" class="btn btn-sm btn-clear btn-icon blue">
      <i class="icon ion-arrow-left-c"></i> View all properties
    </a>
  </div>

  <!-- Property card header -->
  <nav>
    <ul class="nav">
      <li class="sidebar-picture">
        <div>
          <img id="property-photo"
               class="picture-thumb"
               src="img/property-placeholder.jpg"
               alt="Property Photo">
          <span class="custom-badge custom-badge-sm custom-badge-primary font-size-12 property-share-button">
            <i class="icon ion-share"></i> Share
          </span>
          <span class="custom-badge-group">
            <span class="custom-badge custom-badge-sm custom-badge-success text-uppercase font-size-11 cursor-default">
              rental
            </span>
          </span>
        </div>
      </li>

      <!-- Property title block -->
      <li class="content-item">
        <div class="dropdown">
          <h4 id="sidebar-property-title">
            <span id="sidebar-address-line">Address</span>
            <span class="caret absolute-v-center"></span>
          </h4>
        </div>

        <a href="#" class="no-link">
          <p class="margin-b-0" id="sidebar-address-block">
            <!-- e.g. 207 Lorine St<br>Keller, TX 76248 -->
          </p>
          <p class="margin-b-5" id="sidebar-property-meta">
            <!-- e.g. 3 BR · 2 BA · 1,500 Sq.Ft. -->
          </p>
          <p class="margin-b-0">
            <span class="blue bold" id="sidebar-price">$0</span>
            <span class="pull-right">
              <span class="blue" id="sidebar-caprate">
                <span class="bold">0%</span> Cap Rate
              </span>
            </span>
          </p>
        </a>
      </li>

      <!-- Sidebar Nav Sections -->
      <li class="nav-heading"><span>PROPERTY</span></li>
      <li><a href="property-description.php" class=""><i class="icon ion-ios-home blue"></i> Property Description</a></li>
      <li><a href="purchase-worksheet.php" class=""><i class="icon ion-edit blue"></i> Purchase Worksheet</a></li>
      <li><a href="photos.php" class=""><i class="icon ion-images blue"></i> Photos</a></li>
      <li><a href="map.php" class=""><i class="icon ion-ios-location blue"></i> Map</a></li>

      <li class="nav-heading"><span>ANALYSIS</span></li>
      <li class="active">
        <a href="property.php">
          <i class="icon ion-pie-graph blue"></i> Property Analysis
        </a>
      </li>
      <li><a href="buy-hold.php"><i class="icon ion-stats-bars blue"></i> Buy &amp; Hold Projections</a></li>

      <li class="nav-heading"><span>RESEARCH</span></li>
      <li><a href="sales-comps.php"><i class="icon ion-social-usd blue"></i> Sales Comps &amp; ARV</a></li>
      <li><a href="rental-comps.php"><i class="icon ion-key blue"></i> Rental Comps &amp; Rent</a></li>
      <li><a href="records-listings.php"><i class="icon fa fa-clipboard blue"></i> Records &amp; Listings</a></li>
      <li><a href="owner-lookup.php"><i class="icon fa fa-address-book blue"></i> Owner Lookup</a></li>

      <li class="nav-heading"><span>TOOLS</span></li>
      <li><a href="offer-calculator.php"><i class="icon ion-calculator blue"></i> Offer Calculator</a></li>
      <li><a href="reports.php"><i class="icon ion-ios-copy blue"></i> Reports &amp; Sharing</a></li>
      <li><a href="compare.php"><i class="icon ion-arrow-swap blue"></i> Compare Properties</a></li>
      <li><a href="lenders.php"><i class="icon fa fa-university blue"></i> Find Local Lenders</a></li>
      <li>
        <a href="#" class="disabled-link">
          <i class="icon"><img src="img/brands/rentcast-icon.svg" alt="RentCast Logo"></i>
          Track After Purchase
        </a>
      </li>
    </ul>

    <div class="property-action-buttons-bottom text-center">
      <button class="btn btn-sm btn-clear btn-icon red" id="delete-property-btn">
        <i class="icon ion-trash-b"></i> Delete
      </button>
    </div>

  </nav>

</aside>
