<?php
// ============================================================================
// MLS9 – ROOT INDEX
// One entry point for the app. Lives in /colton2/5/index.php
// All pages: /includes/{page}.php  (purchase, analysis, etc.)
// Theme: DealCheck-style light UI with GPT-style address input as Step 1.
// ============================================================================

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Load API keys (if present)
$apiKeysPath = __DIR__ . '/accounts/api_keys.php';
if (file_exists($apiKeysPath)) {
    require_once $apiKeysPath;
}

// Whitelisted pages for router
$allowedPages = [
    'start',          // GPT-style first step
    'purchase',
    'photos',
    'map',
    'analysis',
    'projections',
    'sales-comps',
    'rental-comps',
    'records',
    'owner-lookup',
    'offer-calculator',
    'reports',
    'compare',
    'lenders',
    'track',
    'property',
];

// Resolve current page (default: start screen)
$page = isset($_GET['page']) ? strtolower(trim($_GET['page'])) : 'start';
if (!in_array($page, $allowedPages, true)) {
    $page = 'start';
}

// Address carried across workflow
$address = isset($_GET['address']) ? trim($_GET['address']) : '';

$pageTitles = [
    'start'           => 'Ask MLS9 About Any Property',
    'purchase'        => 'Purchase Details',
    'photos'          => 'Property Photos',
    'map'             => 'Map & Location',
    'analysis'        => 'Deal Analysis',
    'projections'     => 'Cashflow Projections',
    'sales-comps'     => 'Sales Comparables',
    'rental-comps'    => 'Rental Comparables',
    'records'         => 'Property Records',
    'owner-lookup'    => 'Owner Lookup',
    'offer-calculator'=> 'Offer Calculator',
    'reports'         => 'Reports & Exports',
    'compare'         => 'Compare Deals',
    'lenders'         => 'Lenders & Financing',
    'track'           => 'Deal Tracking',
    'property'        => 'Property Overview',
];

$currentTitle = $pageTitles[$page] ?? 'MLS9 Deal Analyzer';

// Only used for non-start pages
$pageFile = __DIR__ . "/includes/{$page}.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>MLS9 – <?php echo htmlspecialchars($currentTitle); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- DealCheck-style light UI + GPT-style input -->
    <style>
        :root {
            --bg-body: #e5e7eb;
            --bg-app: #f3f4f6;
            --bg-card: #ffffff;
            --bg-soft: #f9fafb;
            --border-soft: #e5e7eb;
            --border-strong: #d1d5db;
            --text-main: #111827;
            --text-muted: #6b7280;
            --accent: #2563eb;
            --accent-strong: #1d4ed8;
            --accent-soft: rgba(37,99,235,0.08);
            --radius-xl: 24px;
            --radius-lg: 18px;
            --radius-md: 12px;
            --shadow-soft: 0 22px 60px rgba(15,23,42,0.18);
        }

        * {
            box-sizing: border-box;
        }

        body {
            margin: 0;
            padding: 0;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background:
                radial-gradient(circle at top, #ffffff 0, #e5e7eb 40%, #cbd5e1 100%);
            color: var(--text-main);
        }

        a {
            color: inherit;
            text-decoration: none;
        }

        .mls9-outer {
            min-height: 100vh;
            padding: 24px 12px;
            display: flex;
            justify-content: center;
        }

        .mls9-app {
            width: 100%;
            max-width: 1320px;
            background: var(--bg-app);
            border-radius: var(--radius-xl);
            box-shadow: var(--shadow-soft);
            border: 1px solid rgba(148,163,184,0.6);
            display: flex;
            flex-direction: column;
            overflow: hidden;
        }

        /* HEADER (shared theme) */
        .mls9-header {
            padding: 16px 22px;
            background: linear-gradient(135deg, #ffffff, #f9fafb);
            border-bottom: 1px solid var(--border-soft);
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 16px;
        }

        .header-left {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .logo-pill {
            width: 40px;
            height: 40px;
            border-radius: 14px;
            background: radial-gradient(circle at 20% 20%, #60a5fa, #2563eb);
            display: flex;
            align-items: center;
            justify-content: center;
            color: #f9fafb;
            font-weight: 700;
            font-size: 18px;
        }

        .brand-text {
            display: flex;
            flex-direction: column;
        }

        .brand-title {
            font-size: 18px;
            font-weight: 600;
            letter-spacing: 0.12em;
            text-transform: uppercase;
        }

        .brand-subtitle {
            font-size: 12px;
            color: var(--text-muted);
        }

        .brand-subtitle span {
            color: var(--accent-strong);
        }

        .header-right {
            display: flex;
            align-items: center;
            gap: 8px;
            flex-wrap: wrap;
            justify-content: flex-end;
        }

        .chip {
            padding: 4px 10px;
            border-radius: 999px;
            background: var(--bg-soft);
            border: 1px solid var(--border-soft);
            font-size: 11px;
            color: var(--text-muted);
            white-space: nowrap;
            display: inline-flex;
            align-items: center;
            gap: 6px;
        }

        .chip-dot {
            width: 8px;
            height: 8px;
            border-radius: 999px;
            background: #22c55e;
        }

        .chip.primary {
            background: var(--accent-soft);
            border-color: rgba(37,99,235,0.5);
            color: var(--accent-strong);
        }

        .btn-sm {
            padding: 7px 14px;
            border-radius: 999px;
            border: 1px solid var(--border-soft);
            background: #ffffff;
            font-size: 12px;
            display: inline-flex;
            align-items: center;
            gap: 6px;
            cursor: pointer;
        }

        .btn-sm.primary {
            border-color: transparent;
            background: linear-gradient(135deg, #2563eb, #1d4ed8);
            color: #f9fafb;
            font-weight: 500;
            box-shadow: 0 12px 30px rgba(37,99,235,0.4);
        }

        .btn-sm:hover {
            filter: brightness(0.98);
        }

        .btn-sm .icon {
            font-size: 14px;
        }

        /* START SCREEN (GPT-style) */
        .start-shell {
            flex: 1;
            padding: 22px 22px 24px;
            display: grid;
            grid-template-columns: minmax(0, 2.2fr) minmax(0, 1.2fr);
            gap: 18px;
        }

        @media (max-width: 900px) {
            .start-shell {
                grid-template-columns: minmax(0, 1fr);
            }
        }

        .start-main {
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .start-card {
            background: var(--bg-card);
            border-radius: var(--radius-xl);
            border: 1px solid var(--border-soft);
            padding: 22px 20px 18px;
            box-shadow: var(--shadow-soft);
        }

        .start-title {
            font-size: 24px;
            font-weight: 650;
            margin-bottom: 4px;
        }

        .start-title span {
            background: linear-gradient(135deg, #2563eb, #16a34a);
            -webkit-background-clip: text;
            color: transparent;
        }

        .start-subtitle {
            font-size: 13px;
            color: var(--text-muted);
            margin-bottom: 16px;
        }

        .gpt-input-shell {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 6px 6px 6px 14px;
            border-radius: 999px;
            border: 1px solid var(--border-strong);
            background: #ffffff;
        }

        .gpt-input-shell:focus-within {
            border-color: var(--accent-strong);
            box-shadow: 0 0 0 1px rgba(37,99,235,0.4);
        }

        .gpt-input-label {
            font-size: 12px;
            color: var(--text-muted);
            margin-right: 6px;
            white-space: nowrap;
        }

        .gpt-input-label span {
            color: var(--text-main);
            font-weight: 500;
        }

        .gpt-input-shell input {
            flex: 1;
            border: none;
            outline: none;
            background: transparent;
            font-size: 14px;
            padding: 6px 0;
        }

        .gpt-input-shell input::placeholder {
            color: #9ca3af;
        }

        .gpt-send-btn {
            border-radius: 999px;
            border: none;
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #2563eb, #16a34a);
            color: #f9fafb;
            cursor: pointer;
            flex-shrink: 0;
        }

        .gpt-send-btn span {
            font-size: 16px;
        }

        .gpt-send-btn:hover {
            filter: brightness(1.03);
        }

        .prompt-chips {
            margin-top: 14px;
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
        }

        .prompt-chip {
            padding: 5px 10px;
            border-radius: 999px;
            border: 1px solid var(--border-soft);
            background: var(--bg-soft);
            font-size: 11px;
            color: var(--text-muted);
            cursor: pointer;
        }

        .prompt-chip span {
            color: var(--accent-strong);
        }

        .prompt-chip:hover {
            border-color: rgba(37,99,235,0.6);
            color: var(--text-main);
        }

        .start-meta-row {
            margin-top: 16px;
            display: flex;
            justify-content: space-between;
            gap: 12px;
            font-size: 11px;
            color: var(--text-muted);
        }

        .start-meta-row strong {
            color: var(--text-main);
        }

        /* RIGHT SIDE: PROCESS PREVIEW (still DealCheck-y) */
        .start-side {
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .side-card {
            background: var(--bg-card);
            border-radius: var(--radius-lg);
            border: 1px solid var(--border-soft);
            padding: 14px 14px 12px;
            box-shadow: 0 14px 40px rgba(148,163,184,0.5);
        }

        .side-header {
            display: flex;
            justify-content: space-between;
            align-items: baseline;
            margin-bottom: 8px;
        }

        .side-title {
            font-size: 13px;
            font-weight: 600;
        }

        .side-subtitle {
            font-size: 11px;
            color: var(--text-muted);
        }

        .step-list {
            list-style: none;
            padding: 0;
            margin: 0;
            font-size: 12px;
        }

        .step-item {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 6px 7px;
            border-radius: 999px;
            margin-bottom: 4px;
        }

        .step-item.active {
            background: var(--accent-soft);
            border: 1px solid rgba(37,99,235,0.4);
        }

        .step-bullet {
            width: 18px;
            height: 18px;
            border-radius: 999px;
            border: 1px solid var(--border-soft);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 11px;
            color: var(--text-muted);
        }

        .step-item.active .step-bullet {
            border-color: transparent;
            background: linear-gradient(135deg, #2563eb, #16a34a);
            color: #f9fafb;
        }

        .step-label-main {
            font-weight: 500;
        }

        .step-label-sub {
            font-size: 11px;
            color: var(--text-muted);
        }

        .side-footer {
            margin-top: 10px;
            font-size: 11px;
            color: var(--text-muted);
        }

        .side-footer span {
            color: var(--accent-strong);
            font-weight: 500;
        }

        /* MAIN LAYOUT (non-start pages) */
        .main-shell {
            flex: 1;
            display: grid;
            grid-template-columns: 240px minmax(0, 1fr);
            border-top: 1px solid var(--border-soft);
            min-height: 0;
        }

        @media (max-width: 900px) {
            .main-shell {
                grid-template-columns: minmax(0, 1fr);
            }
        }

        .main-menu {
            background: #f9fafb;
            border-right: 1px solid var(--border-soft);
            padding: 10px 12px;
        }

        .menu-title {
            font-size: 11px;
            letter-spacing: 0.12em;
            text-transform: uppercase;
            color: var(--text-muted);
            margin-bottom: 8px;
        }

        .menu-inner {
            font-size: 13px;
        }

        .main-content {
            padding: 16px 16px 18px;
        }

        .content-card {
            background: var(--bg-card);
            border-radius: var(--radius-lg);
            border: 1px solid var(--border-soft);
            padding: 16px 18px 18px;
            box-shadow: 0 10px 30px rgba(148,163,184,0.4);
            height: 100%;
        }

        .content-header {
            display: flex;
            justify-content: space-between;
            align-items: baseline;
            gap: 12px;
            border-bottom: 1px solid var(--border-soft);
            padding-bottom: 8px;
            margin-bottom: 10px;
        }

        .content-header h1 {
            margin: 0;
            font-size: 18px;
            font-weight: 600;
        }

        .content-header p {
            margin: 0;
            font-size: 12px;
            color: var(--text-muted);
        }

        .content-meta {
            font-size: 11px;
            color: var(--text-muted);
            text-align: right;
        }

        .page-inner {
            margin-top: 6px;
            font-size: 13px;
        }

        .alert-error {
            padding: 10px 12px;
            border-radius: var(--radius-md);
            border: 1px solid rgba(248,113,113,0.5);
            background: #fef2f2;
            color: #b91c1c;
            font-size: 13px;
        }

        .mls9-footer {
            padding: 8px 16px 10px;
            font-size: 11px;
            color: var(--text-muted);
            text-align: right;
            border-top: 1px solid var(--border-soft);
            background: #ffffff;
        }
    </style>

    <script>
        function usePrompt(text) {
            var el = document.getElementById('mls9-address-input');
            if (!el) return;
            el.value = text;
            el.focus();
        }
    </script>
</head>
<body>
<div class="mls9-outer">
    <div class="mls9-app">

        <!-- SHARED HEADER -->
        <header class="mls9-header">
            <div class="header-left">
                <div class="logo-pill">9</div>
                <div class="brand-text">
                    <div class="brand-title">MLS9</div>
                    <div class="brand-subtitle">
                        DealCheck-style analyzer for <span>creative finance real estate</span>
                    </div>
                </div>
            </div>
            <div class="header-right">
                <div class="chip">
                    <span class="chip-dot"></span> Live API ready
                </div>
                <div class="chip primary">
                    <?php echo $page === 'start'
                        ? 'Step 1 · Type any property like a GPT prompt'
                        : htmlspecialchars($currentTitle); ?>
                </div>
                <button class="btn-sm primary" type="button" onclick="window.location.href='?page=start'">
                    <span class="icon">◎</span> New analysis
                </button>
            </div>
        </header>

        <?php if ($page === 'start'): ?>

            <!-- GPT-STYLE START PAGE -->
            <section class="start-shell">
                <div class="start-main">
                    <div class="start-card">
                        <div class="start-title">
                            Ask <span>MLS9</span> about any property.
                        </div>
                        <div class="start-subtitle">
                            Type an address and what you want to do with it, just like you’d talk to GPT.
                            We’ll carry that address into the full DealCheck-style workflow: purchase, analysis,
                            projections, comps and exit strategies.
                        </div>

                        <form class="gpt-input-shell" method="get" action="">
                            <!-- After this, go straight into purchase step -->
                            <input type="hidden" name="page" value="purchase">
                            <div class="gpt-input-label">
                                <span>Prompt</span> · property & strategy
                            </div>
                            <input
                                id="mls9-address-input"
                                type="text"
                                name="address"
                                placeholder="Analyze 123 Main St, Dallas TX as a subto rental with seller finance backup..."
                                value="<?php echo htmlspecialchars($address); ?>"
                                autocomplete="off"
                            >
                            <button class="gpt-send-btn" type="submit">
                                <span>➤</span>
                            </button>
                        </form>

                        <div class="prompt-chips">
                            <div class="prompt-chip"
                                 onclick="usePrompt('Run full subto + rental analysis on 801 Royal Ave Midwest City OK.')">
                                🏠 <span>Full analysis</span> on my subto deal
                            </div>
                            <div class="prompt-chip"
                                 onclick="usePrompt('Compare flip vs BRRRR on a 3/2 in Saginaw TX 76179.')">
                                📊 Compare <span>flip vs BRRRR</span>
                            </div>
                            <div class="prompt-chip"
                                 onclick="usePrompt('Find my max cash offer and seller finance terms for a house in Fort Worth TX.')">
                                💵 Max <span>cash + seller finance</span> offer
                            </div>
                            <div class="prompt-chip"
                                 onclick="usePrompt('Pull sales comps, rental comps, and best exit strategy for a house in Oklahoma City.')">
                                📈 <span>Comps + best exit</span> strategy
                            </div>
                        </div>

                        <div class="start-meta-row">
                            <div>
                                <strong>Step 1 of 4:</strong> GPT-style address & goal  
                                <span>Next: purchase terms → analysis → projections & comps.</span>
                            </div>
                            <div>
                                MLS9 · REI9 · OpenAI · RentCast · Tracerfy
                            </div>
                        </div>
                    </div>
                </div>

                <aside class="start-side">
                    <div class="side-card">
                        <div class="side-header">
                            <div>
                                <div class="side-title">MLS9 workflow preview</div>
                                <div class="side-subtitle">Same flow as DealCheck, tuned for creative finance.</div>
                            </div>
                        </div>

                        <ul class="step-list">
                            <li class="step-item active">
                                <div class="step-bullet">1</div>
                                <div>
                                    <div class="step-label-main">GPT intake: address & strategy</div>
                                    <div class="step-label-sub">You talk, MLS9 listens: address, hold/flip, subto, seller finance.</div>
                                </div>
                            </li>
                            <li class="step-item">
                                <div class="step-bullet">2</div>
                                <div>
                                    <div class="step-label-main">Purchase · Deal structure</div>
                                    <div class="step-label-sub">Price, terms, subto, seller finance, novation, wrap, cash + refi.</div>
                                </div>
                            </li>
                            <li class="step-item">
                                <div class="step-bullet">3</div>
                                <div>
                                    <div class="step-label-main">Analysis · Projections · Comps</div>
                                    <div class="step-label-sub">DealCheck-style numbers, but tuned for MLS9 creative finance.</div>
                                </div>
                            </li>
                            <li class="step-item">
                                <div class="step-bullet">4</div>
                                <div>
                                    <div class="step-label-main">Best entry & exit</div>
                                    <div class="step-label-sub">AI suggests the most profitable buy + sell combo.</div>
                                </div>
                            </li>
                        </ul>

                        <div class="side-footer">
                            When you hit enter, MLS9 sends you to the <span>Purchase</span> tab with this address pre-loaded,
                            so the rest of your analysis flows exactly like the other DealCheck-style pages we’ve built.
                        </div>
                    </div>
                </aside>
            </section>

        <?php else: ?>

            <!-- NORMAL DEALCHECK-STYLE LAYOUT FOR ALL OTHER PAGES -->
            <main class="main-shell">
                <aside class="main-menu">
                    <div class="menu-title">Workflow</div>
                    <div class="menu-inner">
                        <?php
                        // Your existing DealCheck-style menu tabs
                        $menuFile = __DIR__ . '/includes/menu.php';
                        if (file_exists($menuFile)) {
                            // menu.php can use $page and $address if it wants
                            include $menuFile;
                        } else {
                            echo '<div class="alert-error">Menu file missing: includes/menu.php</div>';
                        }
                        ?>
                    </div>
                </aside>

                <section class="main-content">
                    <div class="content-card">
                        <div class="content-header">
                            <div>
                                <h1><?php echo htmlspecialchars($currentTitle); ?></h1>
                                <p>
                                    MLS9 · Complete the
                                    <strong><?php echo htmlspecialchars(ucfirst(str_replace('-', ' ', $page))); ?></strong>
                                    step of your DealCheck-style workflow.
                                </p>
                            </div>
                            <div class="content-meta">
                                <div>Page: <?php echo htmlspecialchars($page); ?></div>
                                <div>
                                    Address:
                                    <?php echo $address !== '' ? htmlspecialchars($address) : 'Not set'; ?>
                                </div>
                            </div>
                        </div>

                        <div class="page-inner">
                            <?php
                            if (file_exists($pageFile)) {
                                include $pageFile;
                            } else {
                                echo '<div class="alert-error">Page file not found: '
                                    . htmlspecialchars($pageFile) . '</div>';
                            }
                            ?>
                        </div>
                    </div>
                </section>
            </main>

        <?php endif; ?>

        <footer class="mls9-footer">
            MLS9 Deal Analyzer · REI9 · <?php echo date('Y'); ?>
        </footer>
    </div>
</div>
</body>
</html>
