-- sql/schema.sql
-- MySQL schema for MLS9 property cache

CREATE TABLE IF NOT EXISTS properties (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  normalized_address VARCHAR(255) NOT NULL,
  address_line1 VARCHAR(255) DEFAULT NULL,
  city VARCHAR(128) DEFAULT NULL,
  state VARCHAR(16) DEFAULT NULL,
  zip VARCHAR(16) DEFAULT NULL,
  formatted_address VARCHAR(255) DEFAULT NULL,
  beds DECIMAL(4,1) DEFAULT NULL,
  baths DECIMAL(4,1) DEFAULT NULL,
  sqft INT DEFAULT NULL,
  property_type VARCHAR(64) DEFAULT NULL,
  est_value DECIMAL(15,2) DEFAULT NULL,
  est_rent DECIMAL(15,2) DEFAULT NULL,
  rentcast_property LONGTEXT,
  rentcast_value LONGTEXT,
  rentcast_rent LONGTEXT,
  worksheet LONGTEXT,
  mls9_data LONGTEXT,
  created_at DATETIME NOT NULL,
  updated_at DATETIME NOT NULL,
  PRIMARY KEY (id),
  UNIQUE KEY uniq_normalized_address (normalized_address),
  KEY idx_city_state (city, state),
  KEY idx_zip (zip)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
