<?php
// api/rentcast_client.php

require_once __DIR__ . '/db.php';

function mls9_rentcast_request($endpoint, $params = []) {
    $config = require __DIR__ . '/config.php';
    $rc = $config['rentcast'];
    if (empty($rc['enabled']) || empty($rc['api_key'])) {
        return null;
    }

    $url = rtrim($rc['base_url'], '/') . '/' . ltrim($endpoint, '/');
    if (!empty($params)) {
        $url .= '?' . http_build_query($params);
    }

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            'Accept: application/json',
            'X-Api-Key: ' . $rc['api_key'],
        ],
        CURLOPT_TIMEOUT => 20,
    ]);
    $resp = curl_exec($ch);
    if ($resp === false) {
        curl_close($ch);
        return null;
    }
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if ($code >= 200 && $code < 300) {
        return json_decode($resp, true);
    }
    return null;
}

/**
 * Fetch all property-related data from RentCast for a given address.
 * This assumes RentCast has endpoints similar to:
 *   /properties
 *   /avm/value
 *   /avm/rent
 */
function mls9_fetch_rentcast_bundle($address, $city = '', $state = '', $zip = '') {
    $paramsBase = [
        'address' => $address,
    ];
    if ($city) $paramsBase['city'] = $city;
    if ($state) $paramsBase['state'] = $state;
    if ($zip) $paramsBase['zip'] = $zip;

    $property = mls9_rentcast_request('properties', $paramsBase);
    $value = mls9_rentcast_request('avm/value', $paramsBase);
    $rent = mls9_rentcast_request('avm/rent', $paramsBase);

    return [
        'property' => $property,
        'value' => $value,
        'rent' => $rent,
    ];
}
