<?php
// saved.php
// Displays a list of homes that the user has saved. This demo uses the
// isSaved property in the mock listings data. In a real application this
// would be tied to a user account and stored in a database.

require_once __DIR__ . '/data.php';
include __DIR__ . '/header.php';

// Filter listings to only those marked as saved
$saved = array_filter($listings, function ($listing) {
    return !empty($listing['isSaved']);
});

?>

<div class="page">
    <div class="page-header">
        <h1>Saved homes</h1>
        <p>Keep track of homes you love and review them anytime.</p>
    </div>

    <?php if (empty($saved)): ?>
        <div class="empty-state">
            <h3>No saved homes yet</h3>
            <p>Tap the heart icon on any home card to save it here.</p>
        </div>
    <?php else: ?>
        <div class="listing-grid">
            <?php foreach ($saved as $listing): ?>
                <a href="/zillow/z0.0/listing.php?id=<?php echo urlencode($listing['id']); ?>" class="listing-card">
                    <div class="listing-card-image-wrap">
                        <img src="<?php echo htmlspecialchars($listing['imageUrl']); ?>" alt="<?php echo htmlspecialchars($listing['address']); ?>" class="listing-card-image">
                        <?php if (!empty($listing['badge'])): ?>
                            <span class="badge"><?php echo htmlspecialchars($listing['badge']); ?></span>
                        <?php endif; ?>
                        <?php if ($listing['isSaved']): ?>
                            <span class="listing-heart">♥</span>
                        <?php endif; ?>
                    </div>
                    <div class="listing-card-body">
                        <div class="listing-price">$<?php echo number_format($listing['price']); ?></div>
                        <div class="listing-meta">
                            <span><?php echo (int)$listing['beds']; ?> bd</span> ·
                            <span><?php echo (int)$listing['baths']; ?> ba</span> ·
                            <span><?php echo number_format($listing['sqft']); ?> sqft</span>
                        </div>
                        <div class="listing-address"><?php echo htmlspecialchars($listing['address']); ?></div>
                        <div class="listing-subtext">
                            <?php echo htmlspecialchars($listing['city'] . ', ' . $listing['state'] . ' ' . $listing['zip']); ?>
                        </div>
                    </div>
                </a>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>

<?php
include __DIR__ . '/footer.php';