<?php
// sell.php
// Page for homeowners looking to sell their properties. Provides a simple
// estimate request form and a link to find a local agent. In a real
// application you would process the form submission and connect to a back‑end.

include __DIR__ . '/header.php';
?>

<div class="page">
    <div class="page-header">
        <h1>Sell your home with Home9</h1>
        <p>Get an instant value estimate, and connect with local experts to list your property.</p>
    </div>

    <div class="sell-layout">
        <section class="sell-card">
            <h2>See what your home could be worth</h2>
            <p>Enter your address and we’ll show an estimated value range based on market trends.</p>
            <form class="sell-form" onsubmit="event.preventDefault(); alert('Thank you! We will contact you with your estimate.');">
                <input type="text" placeholder="Street address" required>
                <input type="text" placeholder="City, State, ZIP" required>
                <button class="primary-btn" type="submit">Get estimate</button>
            </form>
        </section>

        <section class="sell-card">
            <h2>Partner with a local expert</h2>
            <p>We’ll match you with experienced agents who know your neighborhood.</p>
            <button class="secondary-btn" type="button" onclick="alert('We will connect you with a local expert soon!')">Find an agent</button>
        </section>
    </div>
</div>

<?php
include __DIR__ . '/footer.php';