<?php
require_once __DIR__ . '/auth.php';

$user = require_login();
$page_title = 'Account dashboard';

include __DIR__ . '/header.php';
?>

<h1>Welcome, <?php echo htmlspecialchars($user['first_name']); ?> 👋</h1>
<p class="sub">
    You are logged in. You can now connect this user to your deal analyzer or other tools.
</p>

<p style="font-size:0.9rem; color:#4b5563; margin-bottom:16px;">
    From here, you can:
</p>
<ul style="font-size:0.9rem; color:#374151; padding-left:20px; margin-top:0; margin-bottom:18px;">
    <li>Protect any page in your analyzer by including <code>require_login()</code> from <code>auth.php</code>.</li>
    <li>Use <code>$user['user_id']</code> or <code>$user['email']</code> to associate saved deals.</li>
</ul>

<a href="logout.php" class="muted-link"><span>Log out</span></a>

<?php include __DIR__ . '/footer.php'; ?>
