<?php
// header.php
if (!isset($page_title)) {
    $page_title = 'Accounts';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo htmlspecialchars($page_title); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        :root {
            --bg: #f5f5f7;
            --card-bg: #ffffff;
            --primary: #2563eb;
            --primary-hover: #1d4ed8;
            --border: #e5e7eb;
            --text: #111827;
            --muted: #6b7280;
            --danger: #dc2626;
        }
        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background: var(--bg);
            color: var(--text);
        }
        .page-wrap {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 24px;
        }
        .card {
            width: 100%;
            max-width: 420px;
            background: var(--card-bg);
            border-radius: 16px;
            padding: 24px 24px 32px;
            box-shadow: 0 18px 45px rgba(15, 23, 42, 0.10);
            border: 1px solid var(--border);
        }
        h1 {
            margin: 0 0 4px;
            font-size: 1.6rem;
        }
        p.sub {
            margin: 0 0 20px;
            font-size: 0.9rem;
            color: var(--muted);
        }
        .field {
            margin-bottom: 14px;
        }
        .field label {
            display: block;
            font-size: 0.85rem;
            margin-bottom: 4px;
            color: var(--muted);
        }
        .field input {
            width: 100%;
            padding: 9px 11px;
            border-radius: 10px;
            border: 1px solid var(--border);
            font-size: 0.95rem;
            outline: none;
        }
        .field input:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 1px rgba(37, 99, 235, 0.15);
        }
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 100%;
            padding: 10px 14px;
            border-radius: 999px;
            border: none;
            background: var(--primary);
            color: #ffffff;
            font-size: 0.95rem;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.15s ease, transform 0.05s ease;
        }
        .btn:hover {
            background: var(--primary-hover);
        }
        .btn:active {
            transform: translateY(1px);
        }
        .muted-link {
            display: inline-block;
            margin-top: 8px;
            font-size: 0.85rem;
            color: var(--muted);
            text-decoration: none;
        }
        .muted-link span {
            color: var(--primary);
        }
        .muted-link:hover span {
            text-decoration: underline;
        }
        .error {
            margin-bottom: 12px;
            padding: 8px 10px;
            border-radius: 10px;
            background: #fef2f2;
            color: var(--danger);
            font-size: 0.85rem;
            border: 1px solid #fecaca;
        }
        .success {
            margin-bottom: 12px;
            padding: 8px 10px;
            border-radius: 10px;
            background: #ecfdf3;
            color: #15803d;
            font-size: 0.85rem;
            border: 1px solid #bbf7d0;
        }
    </style>
</head>
<body>
<div class="page-wrap">
    <div class="card">
