<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';

$page_title = 'Sign in';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email    = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if ($email === '' || $password === '') {
        $error = 'Please enter your email and password.';
    } else {
        $pdo = get_pdo();

        $stmt = $pdo->prepare("SELECT user_id, password_hash, is_active FROM users WHERE email = :email LIMIT 1");
        $stmt->execute([':email' => $email]);
        $user = $stmt->fetch();

        if (!$user) {
            $error = 'Incorrect email or password.';
        } elseif (!$user['is_active']) {
            $error = 'This account is inactive. Please contact support.';
        } elseif (!password_verify($password, $user['password_hash'])) {
            $error = 'Incorrect email or password.';
        } else {
            create_session($user['user_id']);
            header('Location: dashboard.php');
            exit;
        }
    }
}

include __DIR__ . '/header.php';
?>

<h1>Sign in</h1>
<p class="sub">Use your account to access the analyzer and tools.</p>

<?php if ($error): ?>
    <div class="error"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<form method="post" action="login.php" autocomplete="on">
    <div class="field">
        <label for="email">Email</label>
        <input id="email" name="email" type="email" required value="<?php echo isset($email) ? htmlspecialchars($email) : ''; ?>">
    </div>
    <div class="field">
        <label for="password">Password</label>
        <input id="password" name="password" type="password" required>
    </div>
    <button class="btn" type="submit">Sign in</button>
</form>

<a href="register.php" class="muted-link">Need an account? <span>Create one</span></a>

<?php include __DIR__ . '/footer.php'; ?>
