<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';

$page_title = 'Create your account';

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $first_name = trim($_POST['first_name'] ?? '');
    $last_name  = trim($_POST['last_name'] ?? '');
    $email      = trim($_POST['email'] ?? '');
    $password   = $_POST['password'] ?? '';

    if ($first_name === '' || $last_name === '' || $email === '' || $password === '') {
        $error = 'Please fill in all fields.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Please enter a valid email address.';
    } elseif (strlen($password) < 8) {
        $error = 'Password must be at least 8 characters.';
    } else {
        $pdo = get_pdo();

        // Check if email exists
        $stmt = $pdo->prepare("SELECT user_id FROM users WHERE email = :email LIMIT 1");
        $stmt->execute([':email' => $email]);
        if ($stmt->fetch()) {
            $error = 'An account with this email already exists.';
        } else {
            $password_hash = password_hash($password, PASSWORD_DEFAULT);

            $stmt = $pdo->prepare("
                INSERT INTO users (email, password_hash, first_name, last_name)
                VALUES (:email, :hash, :first, :last)
            ");
            $stmt->execute([
                ':email' => $email,
                ':hash'  => $password_hash,
                ':first' => $first_name,
                ':last'  => $last_name,
            ]);

            $user_id = $pdo->lastInsertId();
            create_session($user_id);

            header('Location: dashboard.php');
            exit;
        }
    }
}

include __DIR__ . '/header.php';
?>

<h1>Create your account</h1>
<p class="sub">This login will be used for your deal analyzer and future tools.</p>

<?php if ($error): ?>
    <div class="error"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<form method="post" action="register.php" autocomplete="on">
    <div class="field">
        <label for="first_name">First name</label>
        <input id="first_name" name="first_name" type="text" required value="<?php echo isset($first_name) ? htmlspecialchars($first_name) : ''; ?>">
    </div>
    <div class="field">
        <label for="last_name">Last name</label>
        <input id="last_name" name="last_name" type="text" required value="<?php echo isset($last_name) ? htmlspecialchars($last_name) : ''; ?>">
    </div>
    <div class="field">
        <label for="email">Email</label>
        <input id="email" name="email" type="email" required value="<?php echo isset($email) ? htmlspecialchars($email) : ''; ?>">
    </div>
    <div class="field">
        <label for="password">Password</label>
        <input id="password" name="password" type="password" required>
    </div>
    <button class="btn" type="submit">Sign up</button>
</form>

<a href="login.php" class="muted-link">Already have an account? <span>Sign in</span></a>

<?php include __DIR__ . '/footer.php'; ?>
