<?php
require_once "menu.php";
require_once "db.php";

// If property_id is passed, load data
$property_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$property = null;
$sales_comps = [];
$rental_comps = [];

if ($property_id > 0) {
    // PROPERTY DATA
    $stmt = $conn->prepare("SELECT * FROM properties WHERE id = ?");
    $stmt->bind_param("i", $property_id);
    $stmt->execute();
    $property = $stmt->get_result()->fetch_assoc();
    $stmt->close();

    // SALES COMPS
    $stmt = $conn->prepare("SELECT * FROM sales_comps WHERE property_id = ?");
    $stmt->bind_param("i", $property_id);
    $stmt->execute();
    $sales_comps = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    // RENTAL COMPS
    $stmt = $conn->prepare("SELECT * FROM rental_comps WHERE property_id = ?");
    $stmt->bind_param("i", $property_id);
    $stmt->execute();
    $rental_comps = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Reports</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        .container {
            max-width: 1200px;
            margin: auto;
            padding: 25px;
        }

        h1, h2 {
            margin-bottom: 15px;
        }

        .section-card {
            background: #fff;
            border-radius: 8px;
            padding: 18px;
            margin-bottom: 25px;
            border: 1px solid #e2e2e2;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 12px;
        }

        table th, table td {
            padding: 10px;
            border-bottom: 1px solid #ddd;
        }

        th {
            background: #f5f5f5;
            text-align: left;
        }

        .btn {
            padding: 10px 14px;
            border-radius: 6px;
            border: none;
            cursor: pointer;
            margin-right: 10px;
        }

        .btn-primary {
            background: #1a73e8;
            color: white;
        }

        .btn-secondary {
            background: #555;
            color: white;
        }

        .no-data {
            padding: 15px 0;
            color: #777;
            font-style: italic;
        }
    </style>
</head>
<body>

<div class="container">

    <h1>Property Report</h1>

    <?php if (!$property): ?>
        <div class="section-card">
            <h2>No Property Selected</h2>
            Enter a property address from the Property page to generate a report.
        </div>
    <?php else: ?>

        <!-- SUMMARY -->
        <div class="section-card">
            <h2>Property Summary</h2>

            <p><strong>Address:</strong> <?= $property['formattedAddress'] ?></p>
            <p><strong>Bedrooms:</strong> <?= $property['bedrooms'] ?></p>
            <p><strong>Bathrooms:</strong> <?= $property['bathrooms'] ?></p>
            <p><strong>Square Footage:</strong> <?= number_format($property['squareFootage']) ?></p>
            <p><strong>Lot Size:</strong> <?= number_format($property['lotSize']) ?></p>
            <p><strong>Year Built:</strong> <?= $property['yearBuilt'] ?></p>
            <p><strong>Property Type:</strong> <?= $property['propertyType'] ?></p>
        </div>

        <!-- VALUATION -->
        <div class="section-card">
            <h2>Valuation Summary</h2>

            <p><strong>Estimated Value:</strong> $<?= number_format($property['estimatedValue']) ?></p>
            <p><strong>Value Low:</strong> $<?= number_format($property['estimatedValueLow']) ?></p>
            <p><strong>Value High:</strong> $<?= number_format($property['estimatedValueHigh']) ?></p>
            <p><strong>Confidence Score:</strong> <?= $property['valuationConfidence'] ?></p>
        </div>

        <!-- RENTAL DATA -->
        <div class="section-card">
            <h2>Rental Summary</h2>

            <p><strong>Estimated Rent:</strong> $<?= number_format($property['rentEstimate']) ?></p>
            <p><strong>Rent Low:</strong> $<?= number_format($property['rentEstimateLow']) ?></p>
            <p><strong>Rent High:</strong> $<?= number_format($property['rentEstimateHigh']) ?></p>
            <p><strong>Section 8 Rate:</strong> $<?= number_format($property['rentSection8']) ?></p>
        </div>

        <!-- SALES COMPS -->
        <div class="section-card">
            <h2>Sales Comparables</h2>

            <?php if (count($sales_comps) === 0): ?>
                <div class="no-data">No sales comps found.</div>
            <?php else: ?>
                <table>
                    <thead>
                    <tr>
                        <th>Address</th>
                        <th>Price</th>
                        <th>Sq Ft</th>
                        <th>Price / Sq Ft</th>
                        <th>Date Sold</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($sales_comps as $comp): ?>
                        <tr>
                            <td><?= $comp['address'] ?></td>
                            <td>$<?= number_format($comp['price']) ?></td>
                            <td><?= number_format($comp['squareFootage']) ?></td>
                            <td>$<?= number_format($comp['pricePerSqFt'], 2) ?></td>
                            <td><?= $comp['dateSold'] ?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>

        <!-- RENTAL COMPS -->
        <div class="section-card">
            <h2>Rental Comparables</h2>

            <?php if (count($rental_comps) === 0): ?>
                <div class="no-data">No rental comps found.</div>
            <?php else: ?>
                <table>
                    <thead>
                    <tr>
                        <th>Address</th>
                        <th>Rent</th>
                        <th>Sq Ft</th>
                        <th>Rent / Sq Ft</th>
                        <th>Date Listed</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($rental_comps as $comp): ?>
                        <tr>
                            <td><?= $comp['address'] ?></td>
                            <td>$<?= number_format($comp['rent']) ?></td>
                            <td><?= number_format($comp['squareFootage']) ?></td>
                            <td>$<?= number_format($comp['rentPerSqFt'], 2) ?></td>
                            <td><?= $comp['dateListed'] ?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>

        <!-- EXPORT BUTTONS -->
        <div class="section-card">
            <h2>Export Options</h2>

            <button class="btn btn-primary" onclick="exportPDF()">Export as PDF</button>
            <button class="btn btn-secondary" onclick="exportCSV()">Export CSV</button>
        </div>

    <?php endif; ?>
</div>

<script>
function exportPDF() {
    alert("PDF export endpoint not wired yet, but button is ready.");
}

function exportCSV() {
    alert("CSV export endpoint not wired yet, but button is ready.");
}
</script>

</body>
</html>
