<?php
// ============================================================================
// MLS9 – ROOT INDEX
// This file lives in /colton2/5/index.php  (NOT in /includes)
// Step 1: GPT-style address box
// Next steps: load /includes/*.php based on ?page=
// ============================================================================

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Load API keys if present
$apiKeysPath = __DIR__ . '/accounts/api_keys.php';
if (file_exists($apiKeysPath)) {
    require_once $apiKeysPath;
}

// Allowed pages
$allowedPages = [
    'start',          // GPT-style first screen
    'purchase',
    'photos',
    'map',
    'analysis',
    'projections',
    'sales-comps',
    'rental-comps',
    'records',
    'owner-lookup',
    'offer-calculator',
    'reports',
    'compare',
    'lenders',
    'track',
    'property',
];

// Resolve page
$page = isset($_GET['page']) ? strtolower(trim($_GET['page'])) : 'start';
if (!in_array($page, $allowedPages, true)) {
    $page = 'start';
}

$address = isset($_GET['address']) ? trim($_GET['address']) : '';

$pageTitles = [
    'start'           => 'Ask MLS9 About Any Property',
    'purchase'        => 'Purchase Details',
    'photos'          => 'Property Photos',
    'map'             => 'Map & Location',
    'analysis'        => 'Deal Analysis',
    'projections'     => 'Cashflow Projections',
    'sales-comps'     => 'Sales Comparables',
    'rental-comps'    => 'Rental Comparables',
    'records'         => 'Property Records',
    'owner-lookup'    => 'Owner Lookup',
    'offer-calculator'=> 'Offer Calculator',
    'reports'         => 'Reports & Exports',
    'compare'         => 'Compare Deals',
    'lenders'         => 'Lenders & Financing',
    'track'           => 'Deal Tracking',
    'property'        => 'Property Overview',
];

$currentTitle = $pageTitles[$page] ?? 'MLS9 Deal Analyzer';

// Only used for non-start pages
$pageFile = __DIR__ . "/includes/{$page}.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>MLS9 – <?php echo htmlspecialchars($currentTitle); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <style>
        :root {
            --bg-page: #020617;
            --bg-gradient-inner: #0f172a;
            --bg-gradient-outer: #020617;
            --bg-card: #020617;
            --bg-soft: #020617;
            --border-soft: #1f2937;
            --border-strong: #334155;
            --text-main: #e5e7eb;
            --text-muted: #94a3b8;
            --accent: #22c55e;
            --accent-strong: #16a34a;
            --accent-blue: #38bdf8;
            --accent-soft: rgba(56,189,248,0.12);
            --radius-xl: 24px;
            --radius-lg: 18px;
            --radius-md: 12px;
            --shadow-soft: 0 40px 120px rgba(15,23,42,0.9);
        }

        * {
            box-sizing: border-box;
        }

        body {
            margin: 0;
            padding: 0;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background:
                radial-gradient(circle at top, var(--bg-gradient-inner) 0, var(--bg-gradient-outer) 60%),
                #000;
            color: var(--text-main);
        }

        a {
            color: inherit;
            text-decoration: none;
        }

        .app-outer {
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: stretch;
            padding: 24px 12px;
        }

        .app-shell {
            width: 100%;
            max-width: 1240px;
            background: radial-gradient(circle at top left, #111827 0, #020617 55%);
            border-radius: var(--radius-xl);
            border: 1px solid rgba(148,163,184,0.45);
            box-shadow: var(--shadow-soft);
            display: flex;
            flex-direction: column;
            overflow: hidden;
        }

        /* HEADER */
        .app-header {
            padding: 16px 22px 14px;
            border-bottom: 1px solid var(--border-soft);
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 16px;
            background: radial-gradient(circle at top left, #0b1120 0, #020617 80%);
        }

        .brand-left {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .logo-orb {
            width: 40px;
            height: 40px;
            border-radius: 12px;
            background:
                radial-gradient(circle at 20% 20%, #38bdf8, #1d4ed8 40%, #020617 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 800;
            font-size: 18px;
            color: #e5e7eb;
        }

        .brand-text {
            display: flex;
            flex-direction: column;
        }

        .brand-title {
            font-size: 16px;
            font-weight: 600;
            letter-spacing: 0.18em;
            text-transform: uppercase;
        }

        .brand-subtitle {
            font-size: 11px;
            color: var(--text-muted);
        }

        .brand-subtitle span {
            color: var(--accent-blue);
        }

        .header-right {
            display: flex;
            align-items: center;
            gap: 8px;
            flex-wrap: wrap;
            justify-content: flex-end;
        }

        .chip {
            padding: 4px 10px;
            border-radius: 999px;
            border: 1px solid var(--border-soft);
            background: rgba(15,23,42,0.85);
            font-size: 11px;
            color: var(--text-muted);
            display: inline-flex;
            align-items: center;
            gap: 6px;
        }

        .chip-dot {
            width: 8px;
            height: 8px;
            border-radius: 999px;
            background: #22c55e;
            box-shadow: 0 0 0 5px rgba(34,197,94,0.3);
        }

        .chip.primary {
            border-color: rgba(56,189,248,0.7);
            background: radial-gradient(circle at left, rgba(56,189,248,0.24), rgba(15,23,42,0.9));
            color: #e0f2fe;
        }

        .btn-sm {
            padding: 7px 14px;
            border-radius: 999px;
            border: 1px solid var(--border-soft);
            background: rgba(15,23,42,0.9);
            color: var(--text-main);
            font-size: 12px;
            display: inline-flex;
            align-items: center;
            gap: 6px;
            cursor: pointer;
        }

        .btn-sm.primary {
            border-color: transparent;
            background: linear-gradient(135deg, #22c55e, #38bdf8);
            color: #0b1120;
            font-weight: 600;
            box-shadow: 0 16px 40px rgba(34,197,94,0.45);
        }

        .btn-sm .icon {
            font-size: 14px;
        }

        .btn-sm:hover {
            filter: brightness(1.03);
        }

        /* START SCREEN: GPT-STYLE */
        .start-shell {
            flex: 1;
            padding: 24px 22px 26px;
            display: flex;
            gap: 20px;
        }

        .start-main {
            flex: 2;
            display: flex;
            flex-direction: column;
            justify-content: center;
            padding-right: 10px;
        }

        .start-card {
            background: radial-gradient(circle at top, #020617 0, #020617 60%);
            border-radius: var(--radius-xl);
            border: 1px solid var(--border-strong);
            box-shadow: var(--shadow-soft);
            padding: 22px 20px 18px;
            position: relative;
            overflow: hidden;
        }

        .start-card::before {
            content: "";
            position: absolute;
            inset: -120px;
            background:
                radial-gradient(circle at 10% 0, rgba(56,189,248,0.18) 0, transparent 55%),
                radial-gradient(circle at 90% 0, rgba(34,197,94,0.15) 0, transparent 55%);
            opacity: 0.9;
            pointer-events: none;
        }

        .start-card-inner {
            position: relative;
            z-index: 2;
        }

        .start-title {
            font-size: 26px;
            font-weight: 650;
            margin-bottom: 4px;
        }

        .start-title span {
            background: linear-gradient(135deg, #38bdf8, #22c55e);
            -webkit-background-clip: text;
            color: transparent;
        }

        .start-subtitle {
            font-size: 13px;
            color: var(--text-muted);
            margin-bottom: 18px;
        }

        .gpt-input-shell {
            background: rgba(15,23,42,0.88);
            border-radius: 999px;
            border: 1px solid var(--border-strong);
            padding: 6px 6px 6px 14px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .gpt-input-shell:focus-within {
            border-color: rgba(56,189,248,0.8);
            box-shadow: 0 0 0 1px rgba(56,189,248,0.6);
        }

        .gpt-input-label {
            font-size: 12px;
            color: var(--text-muted);
        }

        .gpt-input-label span {
            color: #e5e7eb;
            font-weight: 500;
        }

        .gpt-input-shell input {
            flex: 1;
            background: transparent;
            border: none;
            outline: none;
            color: var(--text-main);
            font-size: 14px;
            padding: 6px 0;
        }

        .gpt-input-shell input::placeholder {
            color: #4b5563;
        }

        .gpt-send-btn {
            border-radius: 999px;
            border: none;
            background: linear-gradient(135deg, #22c55e, #38bdf8);
            color: #020617;
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            flex-shrink: 0;
        }

        .gpt-send-btn span {
            font-size: 16px;
        }

        .gpt-send-btn:hover {
            filter: brightness(1.08);
        }

        .prompt-chips {
            margin-top: 14px;
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
        }

        .prompt-chip {
            padding: 5px 10px;
            border-radius: 999px;
            background: rgba(15,23,42,0.85);
            border: 1px solid var(--border-soft);
            font-size: 11px;
            color: var(--text-muted);
            cursor: pointer;
        }

        .prompt-chip span {
            color: var(--accent-blue);
        }

        .prompt-chip:hover {
            border-color: rgba(56,189,248,0.7);
            color: #e5e7eb;
        }

        .start-meta-row {
            margin-top: 16px;
            display: flex;
            justify-content: space-between;
            gap: 12px;
            font-size: 11px;
            color: var(--text-muted);
        }

        .start-meta-row strong {
            color: #e5e7eb;
        }

        /* RIGHT SIDE: PROCESS PREVIEW */
        .start-side {
            flex: 1.4;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .side-card {
            background: radial-gradient(circle at top, #020617 0, #0b1120 80%);
            border-radius: var(--radius-lg);
            border: 1px solid var(--border-strong);
            padding: 16px 14px 12px;
            box-shadow: 0 24px 60px rgba(15,23,42,0.9);
        }

        .side-header {
            display: flex;
            justify-content: space-between;
            align-items: baseline;
            margin-bottom: 8px;
        }

        .side-title {
            font-size: 13px;
            font-weight: 600;
        }

        .side-subtitle {
            font-size: 11px;
            color: var(--text-muted);
        }

        .step-list {
            margin: 0;
            padding: 0;
            list-style: none;
            font-size: 12px;
        }

        .step-item {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 6px 7px;
            border-radius: 999px;
            margin-bottom: 4px;
        }

        .step-item.active {
            background: rgba(56,189,248,0.12);
            border: 1px solid rgba(56,189,248,0.6);
        }

        .step-bullet {
            width: 18px;
            height: 18px;
            border-radius: 999px;
            border: 1px solid rgba(148,163,184,0.7);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 11px;
            color: var(--text-muted);
        }

        .step-item.active .step-bullet {
            border-color: transparent;
            background: linear-gradient(135deg, #22c55e, #38bdf8);
            color: #020617;
        }

        .step-label-main {
            font-weight: 500;
        }

        .step-label-sub {
            font-size: 11px;
            color: var(--text-muted);
        }

        .side-footer {
            margin-top: 10px;
            font-size: 11px;
            color: var(--text-muted);
        }

        .side-footer span {
            color: var(--accent);
            font-weight: 500;
        }

        /* MAIN LAYOUT (NON-START PAGES) */
        .main-shell {
            flex: 1;
            display: grid;
            grid-template-columns: 240px minmax(0, 1fr);
            min-height: 0;
        }

        @media (max-width: 900px) {
            .start-shell {
                flex-direction: column;
            }
            .main-shell {
                grid-template-columns: minmax(0, 1fr);
            }
        }

        .main-menu {
            border-right: 1px solid var(--border-soft);
            background: radial-gradient(circle at top left, #020617 0, #020617 80%);
            padding: 10px 12px;
        }

        .menu-title {
            font-size: 11px;
            letter-spacing: 0.16em;
            text-transform: uppercase;
            color: var(--text-muted);
            margin-bottom: 8px;
        }

        .menu-inner {
            font-size: 13px;
        }

        .main-content {
            padding: 16px 16px 18px;
        }

        .content-card {
            background: #020617;
            border-radius: var(--radius-lg);
            border: 1px solid var(--border-strong);
            padding: 16px 18px 18px;
            box-shadow: var(--shadow-soft);
            height: 100%;
        }

        .content-header {
            display: flex;
            justify-content: space-between;
            align-items: baseline;
            gap: 12px;
            border-bottom: 1px solid var(--border-soft);
            padding-bottom: 8px;
            margin-bottom: 10px;
        }

        .content-header h1 {
            margin: 0;
            font-size: 17px;
            font-weight: 600;
        }

        .content-header p {
            margin: 0;
            font-size: 12px;
            color: var(--text-muted);
        }

        .content-meta {
            font-size: 11px;
            color: var(--text-muted);
            text-align: right;
        }

        .page-inner {
            margin-top: 6px;
            font-size: 13px;
        }

        .alert-error {
            padding: 10px 12px;
            border-radius: var(--radius-md);
            border: 1px solid rgba(248,113,113,0.5);
            background: rgba(127,29,29,0.85);
            color: #fee2e2;
            font-size: 13px;
        }

        .app-footer {
            padding: 8px 16px 10px;
            font-size: 11px;
            color: var(--text-muted);
            border-top: 1px solid var(--border-soft);
            background: #020617;
            text-align: right;
        }
    </style>

    <script>
        // Fill the input with example prompts when a chip is clicked
        function usePrompt(text) {
            var el = document.getElementById('mls9-address-input');
            if (!el) return;
            el.value = text;
            el.focus();
        }
    </script>
</head>
<body>
<div class="app-outer">
    <div class="app-shell">

        <!-- HEADER -->
        <header class="app-header">
            <div class="brand-left">
                <div class="logo-orb">9</div>
                <div class="brand-text">
                    <div class="brand-title">MLS9</div>
                    <div class="brand-subtitle">
                        <span>AI-powered</span> deal analyzer for creative real estate
                    </div>
                </div>
            </div>
            <div class="header-right">
                <div class="chip">
                    <span class="chip-dot"></span> Live API ready
                </div>
                <div class="chip primary">
                    First step: Type any property address
                </div>
                <button class="btn-sm primary" type="button" onclick="window.location.href='?page=start'">
                    <span class="icon">◎</span> New analysis
                </button>
            </div>
        </header>

        <?php if ($page === 'start'): ?>

            <!-- GPT-STYLE START SCREEN -->
            <section class="start-shell">
                <div class="start-main">
                    <div class="start-card">
                        <div class="start-card-inner">
                            <div class="start-title">
                                Ask <span>MLS9</span> about any property.
                            </div>
                            <div class="start-subtitle">
                                Just drop in an address like you’re talking to GPT. We’ll handle values, rents,
                                and the best creative finance play behind the scenes.
                            </div>

                            <form class="gpt-input-shell" method="get" action="">
                                <!-- jump straight into purchase step after address -->
                                <input type="hidden" name="page" value="purchase">
                                <input
                                    id="mls9-address-input"
                                    type="text"
                                    name="address"
                                    placeholder="“Analyze 123 Main St, Dallas TX as a subto rental…”"
                                    value="<?php echo htmlspecialchars($address); ?>"
                                    autocomplete="off"
                                >
                                <button class="gpt-send-btn" type="submit">
                                    <span>➤</span>
                                </button>
                            </form>

                            <div class="prompt-chips">
                                <div class="prompt-chip" onclick="usePrompt('Run full analysis on 801 Royal Ave Midwest City OK as a subto rental.')">
                                    🏠 <span>Run full analysis</span> on my subto deal
                                </div>
                                <div class="prompt-chip" onclick="usePrompt('Compare flip vs rental for 3 bed 2 bath in Saginaw TX 76179.')">
                                    📊 Compare <span>flip vs rental</span>
                                </div>
                                <div class="prompt-chip" onclick="usePrompt('Find my max cash offer and seller finance terms for a property in Fort Worth TX.')">
                                    💵 Find my <span>max cash + seller finance offer</span>
                                </div>
                                <div class="prompt-chip" onclick="usePrompt('Pull rents, sales comps, and best exit strategy for a house in Oklahoma City.')">
                                    📈 Rents, comps & <span>best exit</span>
                                </div>
                            </div>

                            <div class="start-meta-row">
                                <div>
                                    <strong>Step 1 of 4</strong> · Address & basic details  
                                    <span style="color: var(--text-muted);">Next: purchase terms, analysis, projections.</span>
                                </div>
                                <div>
                                    Powered by MLS9 · REI9 · OpenAI · RentCast
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <aside class="start-side">
                    <div class="side-card">
                        <div class="side-header">
                            <div>
                                <div class="side-title">MLS9 workflow preview</div>
                                <div class="side-subtitle">What happens after you hit enter.</div>
                            </div>
                        </div>

                        <ul class="step-list">
                            <li class="step-item active">
                                <div class="step-bullet">1</div>
                                <div>
                                    <div class="step-label-main">Address & property AI intake</div>
                                    <div class="step-label-sub">GPT-style prompt → address → core data pull.</div>
                                </div>
                            </li>
                            <li class="step-item">
                                <div class="step-bullet">2</div>
                                <div>
                                    <div class="step-label-main">Purchase & deal structure</div>
                                    <div class="step-label-sub">Subto, seller finance, novation, wrap, cash + refi.</div>
                                </div>
                            </li>
                            <li class="step-item">
                                <div class="step-bullet">3</div>
                                <div>
                                    <div class="step-label-main">Analysis, comps & projections</div>
                                    <div class="step-label-sub">Sales & rental comps, cashflow, DSCR, payback.</div>
                                </div>
                            </li>
                            <li class="step-item">
                                <div class="step-bullet">4</div>
                                <div>
                                    <div class="step-label-main">Best entry + exit strategy</div>
                                    <div class="step-label-sub">AI suggests the most profitable way in and out.</div>
                                </div>
                            </li>
                        </ul>

                        <div class="side-footer">
                            After you press enter, we’ll drop you into the <span>Purchase</span> tab with this
                            address pre-loaded so the rest of the DealCheck-style flow stays seamless.
                        </div>
                    </div>
                </aside>
            </section>

        <?php else: ?>

            <!-- MAIN SHELL FOR ALL OTHER PAGES (PURCHASE, ANALYSIS, ETC) -->
            <main class="main-shell">
                <aside class="main-menu">
                    <div class="menu-title">Workflow</div>
                    <div class="menu-inner">
                        <?php
                        $menuFile = __DIR__ . '/includes/menu.php';
                        if (file_exists($menuFile)) {
                            // If your menu needs $page or $address, they are already set
                            include $menuFile;
                        } else {
                            echo '<div class="alert-error">Menu file missing: includes/menu.php</div>';
                        }
                        ?>
                    </div>
                </aside>

                <section class="main-content">
                    <div class="content-card">
                        <div class="content-header">
                            <div>
                                <h1><?php echo htmlspecialchars($currentTitle); ?></h1>
                                <p>
                                    MLS9 · Complete the
                                    <strong><?php echo htmlspecialchars(ucfirst(str_replace('-', ' ', $page))); ?></strong>
                                    step for this property.
                                </p>
                            </div>
                            <div class="content-meta">
                                <div>Page: <?php echo htmlspecialchars($page); ?></div>
                                <div>Address: <?php echo $address !== '' ? htmlspecialchars($address) : 'Not set'; ?></div>
                            </div>
                        </div>

                        <div class="page-inner">
                            <?php
                            if (file_exists($pageFile)) {
                                include $pageFile;
                            } else {
                                echo '<div class="alert-error">Page file not found: '
                                    . htmlspecialchars($pageFile) . '</div>';
                            }
                            ?>
                        </div>
                    </div>
                </section>
            </main>

        <?php endif; ?>

        <footer class="app-footer">
            MLS9 Deal Analyzer · REI9 · <?php echo date('Y'); ?>
        </footer>
    </div>
</div>
</body>
</html>
