// Shared helpers between pages

function formatCurrency(num) {
  if (num === null || num === undefined || isNaN(num)) return '-';
  const n = Number(num);
  return '$' + n.toLocaleString(undefined, { maximumFractionDigits: 0 });
}

function formatPercent(num) {
  if (num === null || num === undefined || isNaN(num)) return '-';
  return Number(num).toFixed(1) + '%';
}

function getQueryParam(name) {
  const params = new URLSearchParams(window.location.search);
  return params.get(name);
}

// Simple in-browser storage of last properties list
const MLS9_STORAGE_KEY = 'mls9_properties';

function savePropertyToLocalList(property) {
  try {
    const existingRaw = window.localStorage.getItem(MLS9_STORAGE_KEY);
    let list = [];
    if (existingRaw) {
      list = JSON.parse(existingRaw);
    }
    const idx = list.findIndex(p => p.id === property.id);
    if (idx >= 0) {
      list[idx] = property;
    } else {
      list.push(property);
    }
    window.localStorage.setItem(MLS9_STORAGE_KEY, JSON.stringify(list));
  } catch (e) {
    console.warn('Unable to save to localStorage', e);
  }
}

function loadLocalProperties() {
  try {
    const raw = window.localStorage.getItem(MLS9_STORAGE_KEY);
    if (!raw) return [];
    return JSON.parse(raw);
  } catch (e) {
    console.warn('Unable to parse localStorage', e);
    return [];
  }
}
