<?php
// Turn on all errors for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<pre>";
echo "test-db.php starting...\n";

// Check PHP is actually executing
echo "Step 1: PHP is running.\n";

// Figure out where we are
echo "Current __DIR__: " . __DIR__ . "\n";

// Guess config path: /api/config.php under this folder
$configPath = __DIR__ . '/api/config.php';
echo "Looking for config at: {$configPath}\n";

if (!file_exists($configPath)) {
    echo "❌ config.php NOT FOUND at that path.\n";
    echo "Check that the 'api' folder is in the SAME directory as test-db.php.\n";
    echo "</pre>";
    exit;
}

echo "✔ Found config.php, requiring it...\n";

$config = require $configPath;

if (!is_array($config)) {
    echo "❌ config.php did not return an array. Dumping value:\n";
    var_dump($config);
    echo "</pre>";
    exit;
}

if (!isset($config['db'])) {
    echo "❌ config.php does not contain a 'db' key. Dumping config:\n";
    var_dump($config);
    echo "</pre>";
    exit;
}

$db = $config['db'];

echo "\nDB Config Loaded:\n";
echo "Host: {$db['host']}\n";
echo "Database: {$db['name']}\n";
echo "User: {$db['user']}\n";

try {
    $dsn = "mysql:host={$db['host']};dbname={$db['name']};charset=" . ($db['charset'] ?? 'utf8mb4');
    echo "\nAttempting PDO connection with DSN:\n{$dsn}\n";

    $pdo = new PDO($dsn, $db['user'], $db['pass'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);

    echo "\n✅ SUCCESS: Connected to the database!\n";

    // Check properties table
    $stmt = $pdo->query("SHOW TABLES LIKE 'properties'");
    $exists = $stmt->fetch();

    if ($exists) {
        echo "✔ Table 'properties' exists.\n";
    } else {
        echo "❌ Table 'properties' does NOT exist.\n";
    }

} catch (PDOException $e) {
    echo "\n❌ ERROR: Could not connect to DB.\n";
    echo "Message: " . $e->getMessage() . "\n";
}

echo "\nDone.\n";
echo "</pre>";
