<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

require_once __DIR__ . '/config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(["error" => "Method not allowed. Use POST."]);
    exit;
}

$input = file_get_contents("php://input");
$data = json_decode($input, true);

if ($data === null) {
    http_response_code(400);
    echo json_encode(["error" => "Invalid JSON body."]);
    exit;
}

$messages        = $data['messages'] ?? null;
$model           = $data['model'] ?? OPENAI_MODEL;
$temperature     = isset($data['temperature']) ? floatval($data['temperature']) : 0.7;
$maxOutputTokens = isset($data['max_output_tokens']) ? intval($data['max_output_tokens']) : 512;

if (!$messages || !is_array($messages)) {
    http_response_code(400);
    echo json_encode(["error" => "Missing or invalid 'messages' array."]);
    exit;
}

$payload = [
    "model" => $model,
    "messages" => $messages,
    "temperature" => $temperature,
    "max_output_tokens" => $maxOutputTokens
];

$ch = curl_init();

curl_setopt_array($ch, [
    CURLOPT_URL => "https://api.openai.com/v1/chat/completions",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_HTTPHEADER => [
        "Content-Type: application/json",
        "Authorization: Bearer " . OPENAI_API_KEY
    ],
    CURLOPT_POSTFIELDS => json_encode($payload),
    CURLOPT_TIMEOUT => 60
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if (curl_errno($ch)) {
    $error_msg = curl_error($ch);
    curl_close($ch);
    http_response_code(500);
    echo json_encode(["error" => "cURL error: " . $error_msg]);
    exit;
}

curl_close($ch);

http_response_code($httpCode);
echo $response;
?>