<?php
// index.php
// Home page for the Home9 Zillow clone. Displays a hero with a search bar,
// quick tabs for buying/renting/selling, a showcase of featured homes,
// and calls to action for selling your home or exploring mortgages.

require_once __DIR__ . '/data.php';
include __DIR__ . '/header.php';
?>

<div class="home-page">
    <section class="hero">
        <div class="hero-inner">
            <h1>Find your next place to live</h1>
            <p>Search homes for sale, rent, and more in one intuitive experience.</p>
            <form class="searchbar" action="/zillow/z0.0/search.php" method="get">
                <input class="searchbar-input" type="text" name="query" placeholder="Address, neighborhood, city, ZIP">
                <button class="searchbar-btn" type="submit">Search</button>
            </form>
            <div class="hero-tabs">
                <button class="hero-tab hero-tab-active" type="button" onclick="window.location.href='/zillow/z0.0/search.php?for=buy'">Buy</button>
                <button class="hero-tab" type="button" onclick="window.location.href='/zillow/z0.0/rent.php'">Rent</button>
                <button class="hero-tab" type="button" onclick="window.location.href='/zillow/z0.0/sell.php'">Sell</button>
            </div>
        </div>
    </section>

    <section class="home-section">
        <div class="home-section-header">
            <h2>Homes in Texas</h2>
            <button class="link-button" type="button" onclick="window.location.href='/zillow/z0.0/search.php'">View all</button>
        </div>
        <div class="listing-grid">
            <?php foreach ($listings as $listing): ?>
                <a href="/zillow/z0.0/listing.php?id=<?php echo urlencode($listing['id']); ?>" class="listing-card">
                    <div class="listing-card-image-wrap">
                        <img src="<?php echo htmlspecialchars($listing['imageUrl']); ?>" alt="<?php echo htmlspecialchars($listing['address']); ?>" class="listing-card-image">
                        <?php if (!empty($listing['badge'])): ?>
                            <span class="badge"><?php echo htmlspecialchars($listing['badge']); ?></span>
                        <?php endif; ?>
                        <?php if ($listing['isSaved']): ?>
                            <span class="listing-heart">♥</span>
                        <?php endif; ?>
                    </div>
                    <div class="listing-card-body">
                        <div class="listing-price">$<?php echo number_format($listing['price']); ?></div>
                        <div class="listing-meta">
                            <span><?php echo (int)$listing['beds']; ?> bd</span> ·
                            <span><?php echo (int)$listing['baths']; ?> ba</span> ·
                            <span><?php echo number_format($listing['sqft']); ?> sqft</span>
                        </div>
                        <div class="listing-address"><?php echo htmlspecialchars($listing['address']); ?></div>
                        <div class="listing-subtext">
                            <?php echo htmlspecialchars($listing['city'] . ', ' . $listing['state'] . ' ' . $listing['zip']); ?>
                        </div>
                    </div>
                </a>
            <?php endforeach; ?>
        </div>
    </section>

    <section class="home-section home-section-split">
        <div>
            <h2>Sell with confidence</h2>
            <p>Estimate your home’s value, compare market trends, and connect with local experts to list your property.</p>
            <button class="primary-btn" type="button" onclick="window.location.href='/zillow/z0.0/sell.php'">Start selling</button>
        </div>
        <div>
            <h2>Get mortgage guidance</h2>
            <p>Explore rates, run payment scenarios, and understand how much home you can afford—before you start touring.</p>
            <button class="secondary-btn" type="button" onclick="window.location.href='/zillow/z0.0/mortgage.php'">Explore mortgages</button>
        </div>
    </section>
</div>

<?php
include __DIR__ . '/footer.php';