<?php
// data.php
// This file contains mock listing data used across the site.

// Each listing contains information such as price, beds, baths, square footage,
// address, city/state/zip, an image URL, a badge (e.g. "For Sale"), whether
// the user has saved it, and a description. You can add additional entries
// here to expand the catalogue of properties shown on the site.

$listings = [
    [
        'id' => 'TX-123',
        'price' => 425000,
        'beds' => 4,
        'baths' => 3,
        'sqft' => 2450,
        'address' => '123 Oakridge Dr',
        'city' => 'Dallas',
        'state' => 'TX',
        'zip' => '75201',
        'imageUrl' => 'https://images.pexels.com/photos/1396122/pexels-photo-1396122.jpeg',
        'badge' => 'For Sale',
        'isSaved' => true,
        'description' => 'Beautifully updated home in a quiet cul-de-sac with open concept living, modern kitchen, and large backyard.',
                'rentcast' => [
            'rentEstimate'     => 2500,
            'avgRent1br'       => 1800,
            'avgRent2br'       => 2200,
            'avgRent3br'       => 2600,
            'avgRent4br'       => 3000,
            'vacancyRate'      => 5.2,
            'capRate'          => 6.1,
            'rentalGrowthYoy'  => 3.7,
            'medianDaysOnMarket' => 26
        ],
    ],
    [
        'id' => 'TX-124',
        'price' => 319000,
        'beds' => 3,
        'baths' => 2,
        'sqft' => 1850,
        'address' => '456 Lakeview Ln',
        'city' => 'Plano',
        'state' => 'TX',
        'zip' => '75023',
        'imageUrl' => 'https://images.pexels.com/photos/106399/pexels-photo-106399.jpeg',
        'badge' => 'Open House',
        'isSaved' => false,
        'description' => 'Charming single‑family home close to parks, trails, and shopping, featuring vaulted ceilings and natural light.',
                'rentcast' => [
            'rentEstimate'     => 2000,
            'avgRent1br'       => 1500,
            'avgRent2br'       => 1900,
            'avgRent3br'       => 2200,
            'avgRent4br'       => 2500,
            'vacancyRate'      => 4.8,
            'capRate'          => 5.7,
            'rentalGrowthYoy'  => 4.1,
            'medianDaysOnMarket' => 30
        ],
    ],
    [
        'id' => 'TX-125',
        'price' => 589000,
        'beds' => 5,
        'baths' => 4,
        'sqft' => 3200,
        'address' => '789 Ridgeway St',
        'city' => 'Frisco',
        'state' => 'TX',
        'zip' => '75034',
        'imageUrl' => 'https://images.pexels.com/photos/259588/pexels-photo-259588.jpeg',
        'badge' => 'New',
        'isSaved' => false,
        'description' => 'Spacious modern home with designer finishes, media room, and covered patio in a desirable neighborhood.',
                'rentcast' => [
            'rentEstimate'     => 3200,
            'avgRent1br'       => 2000,
            'avgRent2br'       => 2400,
            'avgRent3br'       => 2800,
            'avgRent4br'       => 3400,
            'vacancyRate'      => 6.0,
            'capRate'          => 6.5,
            'rentalGrowthYoy'  => 3.2,
            'medianDaysOnMarket' => 22
        ],
    ],
];
