<?php
// header.php
// Shared header included on every page. Contains the logo, navigation, search bar,
// and account menu. It uses Bootstrap‑inspired flexbox utilities defined in
// styles.css to layout the elements. The active page is highlighted based on
// the current URL path.

// Determine current path without query string for active nav highlighting
$currentPath = strtok($_SERVER['REQUEST_URI'], '?');

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Home9 – Find your next home</title>
    <link rel="stylesheet" href="/zillow/z0.0/assets/css/styles.css">
    <script defer src="/zillow/z0.0/assets/js/script.js"></script>
</head>
<body>
    <header class="header">
        <div class="header-inner">
            <a href="/zillow/z0.0/index.php" class="logo">
                <span class="logo-icon">9</span>
                <span class="logo-text">Home9</span>
            </a>

            <form class="searchbar header-search" action="/zillow/z0.0/search.php" method="get">
                <input
                    class="searchbar-input"
                    type="text"
                    name="query"
                    placeholder="Search for city, neighborhood, address…"
                    value="<?php echo isset($_GET['query']) ? htmlspecialchars($_GET['query']) : ''; ?>"
                >
                <button class="searchbar-btn" type="submit">Search</button>
            </form>

            <nav class="header-nav">
                <a href="/zillow/z0.0/search.php?for=buy" class="nav-link<?php echo strpos($currentPath, '/search.php') !== false && isset($_GET['for']) && $_GET['for'] === 'buy' ? ' active' : ''; ?>">Buy</a>
                <a href="/zillow/z0.0/rent.php" class="nav-link<?php echo $currentPath === '/zillow/z0.0/rent.php' ? ' active' : ''; ?>">Rent</a>
                <a href="/zillow/z0.0/sell.php" class="nav-link<?php echo $currentPath === '/zillow/z0.0/sell.php' ? ' active' : ''; ?>">Sell</a>
                <a href="/zillow/z0.0/mortgage.php" class="nav-link<?php echo $currentPath === '/zillow/z0.0/mortgage.php' ? ' active' : ''; ?>">Mortgages</a>
                <a href="/zillow/z0.0/saved.php" class="nav-link<?php echo $currentPath === '/zillow/z0.0/saved.php' ? ' active' : ''; ?>">Saved</a>
            </nav>

            <div class="header-user">
                <div class="avatar-menu" id="avatarMenu">
                    <button class="avatar-btn" type="button" onclick="toggleAvatarMenu()">
                        <span class="avatar-circle">CA</span>
                    </button>
                    <div class="avatar-dropdown" id="avatarDropdown" style="display:none;">
                        <a href="/zillow/z0.0/profile.php">Profile</a>
                        <a href="/zillow/z0.0/saved.php">Saved homes</a>
                        <a href="/zillow/z0.0/login.php">Sign in</a>
                        <a href="/zillow/z0.0/register.php">Create account</a>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <main class="app-main">