<?php
// listing.php
// Displays details for a single property based on its ID passed via query
// parameter. If the listing does not exist, a friendly error is shown.

require_once __DIR__ . '/data.php';
include __DIR__ . '/header.php';

// Extract ID from the query string
$id = isset($_GET['id']) ? $_GET['id'] : '';

// Find the listing with the given ID
$current = null;
foreach ($listings as $listing) {
    if ($listing['id'] === $id) {
        $current = $listing;
        break;
    }
}

if (!$current): ?>
    <div class="page">
        <h1>Home not found</h1>
        <p>This listing may have been removed or is not available.</p>
    </div>
    <?php include __DIR__ . '/footer.php';
    return;
endif;

// Calculate a simple monthly cost estimate (principal & interest) using
// approximate 0.6% per year of price divided by 10 to approximate tax
// and insurance; this is purely illustrative and not intended to be
// accurate financial advice.
$monthlyEstimate = round(($current['price'] * 0.006) / 10, -1);

?>

<div class="listing-detail-page">
    <div class="listing-detail-gallery">
        <img src="<?php echo htmlspecialchars($current['imageUrl']); ?>" alt="<?php echo htmlspecialchars($current['address']); ?>">
    </div>

    <div class="listing-detail-main">
        <div class="listing-detail-info">
            <div class="listing-detail-price-row">
                <h1>$<?php echo number_format($current['price']); ?></h1>
                <span class="listing-detail-meta">
                    <?php echo (int)$current['beds']; ?> bd ·
                    <?php echo (int)$current['baths']; ?> ba ·
                    <?php echo number_format($current['sqft']); ?> sqft
                </span>
            </div>
            <div class="listing-detail-address">
                <?php echo htmlspecialchars($current['address'] . ', ' . $current['city'] . ', ' . $current['state'] . ' ' . $current['zip']); ?>
            </div>

            <section class="detail-section">
                <h2>Overview</h2>
                <p><?php echo htmlspecialchars($current['description']); ?></p>
            </section>

            <section class="detail-section detail-section-grid">
                <div>
                    <h3>Facts &amp; features</h3>
                    <ul class="detail-list">
                        <li>Type: Single family residence</li>
                        <li>Year built: 2017</li>
                        <li>Heating: Central</li>
                        <li>Cooling: Central air</li>
                        <li>Parking: 2‑car garage</li>
                        <li>HOA: $45/month (example)</li>
                    </ul>
                </div>
                <div>
                    <h3>Monthly cost estimate</h3>
                    <p class="detail-highlight">$<?php echo number_format($monthlyEstimate); ?> / month</p>
                    <ul class="detail-list small">
                        <li>Principal &amp; interest</li>
                        <li>Property taxes</li>
                        <li>Home insurance</li>
                        <li>HOA fees (if applicable)</li>
                    </ul>
                    <button class="primary-btn full" type="button" onclick="window.location.href='/zillow/z0.0/mortgage.php'">Get pre‑qualified</button>
                </div>
     
       <?php if (isset($current['rentcast']) && is_array($current['rentcast'])) { ?>
       
          
          
          
                
            <!-- RentCast data section. These values are placeholders provided in data.php
                 and demonstrate how additional rental insights from the RentCast API
                 could be displayed. Replace or augment this section with live API
                 values as needed. -->
            <section class="detail-section">
                <h2>Rental insights</h2>
                <p>Key metrics based on RentCast data for this property and its surrounding market.</p>
                <ul class="detail-list">
                    <?php if (isset($current['rentcast']['rentEstimate'])): ?>
                    <li>Estimated monthly rent: $<?php echo number_format($current['rentcast']['rentEstimate']); ?></li>
                    <?php endif; ?>
                    <?php if (isset($current['rentcast']['avgRent1br'])): ?>
                    <li>Average 1BR rent in area: $<?php echo number_format($current['rentcast']['avgRent1br']); ?></li>
                    <?php endif; ?>
                    <?php if (isset($current['rentcast']['avgRent2br'])): ?>
                    <li>Average 2BR rent in area: $<?php echo number_format($current['rentcast']['avgRent2br']); ?></li>
                    <?php endif; ?>
                    <?php if (isset($current['rentcast']['avgRent3br'])): ?>
                    <li>Average 3BR rent in area: $<?php echo number_format($current['rentcast']['avgRent3br']); ?></li>
                    <?php endif; ?>
                    <?php if (isset($current['rentcast']['avgRent4br'])): ?>
                    <li>Average 4BR rent in area: $<?php echo number_format($current['rentcast']['avgRent4br']); ?></li>
                    <?php endif; ?>
                    <?php if (isset($current['rentcast']['vacancyRate'])): ?>
                    <li>Vacancy rate: <?php echo number_format($current['rentcast']['vacancyRate'], 1); ?>%</li>
                    <?php endif; ?>
                    <?php if (isset($current['rentcast']['capRate'])): ?>
                    <li>Cap rate: <?php echo number_format($current['rentcast']['capRate'], 1); ?>%</li>
                    <?php endif; ?>
                    <?php if (isset($current['rentcast']['rentalGrowthYoy'])): ?>
                    <li>Year-over-year rental growth: <?php echo number_format($current['rentcast']['rentalGrowthYoy'], 1); ?>%</li>
                    <?php endif; ?>
                    <?php if (isset($current['rentcast']['medianDaysOnMarket'])): ?>
                    <li>Median days on market: <?php echo (int)$current['rentcast']['medianDaysOnMarket']; ?> days</li>
                    <?php endif; ?>
                </ul>
            </section>
          <?php } ?>
     

            <section class="detail-section">
                <h2>Neighborhood</h2>
                <p>Show commute times, nearby schools, and neighborhood statistics here. This section can be powered by your own data APIs.</p>
            </section>
        </div>

        <aside class="listing-detail-sidebar">
            <div class="detail-card">
                <h3>Contact an agent</h3>
                <p>Connect with a local professional to learn more about this home.</p>
                <form class="detail-form" onsubmit="event.preventDefault(); alert('Thank you! An agent will reach out.');">
                    <input type="text" placeholder="Name" required>
                    <input type="email" placeholder="Email" required>
                    <input type="tel" placeholder="Phone" required>
                    <textarea placeholder="I'm interested in this home."></textarea>
                    <button class="primary-btn full" type="submit">Request info</button>
                </form>
            </div>

            <div class="detail-card">
                <h3>Tour this home</h3>
                <p>Select a date to schedule an in‑person or virtual tour.</p>
                <input type="date" style="width:100%; margin-bottom:8px; padding:8px; border-radius:10px; border:1px solid var(--border-subtle);">
                <button class="secondary-btn full" type="button" onclick="alert('Your tour request has been submitted!')">Schedule a tour</button>
            </div>
        </aside>
    </div>
</div>

<?php
include __DIR__ . '/footer.php';