<?php
// mortgage.php
// Mortgage calculator page that allows users to adjust home price, down
// payment, interest rate and term to see estimated monthly payments. The
// calculation logic resides in script.js and is triggered on input events.

include __DIR__ . '/header.php';
?>

<div class="page">
    <div class="page-header">
        <h1>Mortgage calculator</h1>
        <p>Estimate your monthly payment and understand how price, rate, and down payment affect affordability.</p>
    </div>

    <div class="mortgage-layout">
        <div class="mortgage-form-card">
            <label>
                Home price
                <input type="number" id="homePrice" value="400000" min="0" step="1000">
            </label>
            <label>
                Down payment (%)
                <input type="number" id="downPayment" value="20" min="0" max="100" step="1">
            </label>
            <label>
                Interest rate (%)
                <input type="number" id="rate" value="6.5" min="0" step="0.01">
            </label>
            <label>
                Term (years)
                <input type="number" id="term" value="30" min="1" step="1">
            </label>
        </div>
        <div class="mortgage-result-card">
            <h2>Estimated payment</h2>
            <p id="monthlyPayment" class="mortgage-payment"></p>
            <p class="muted">Principal &amp; interest only. Taxes, insurance, and HOA fees can change your total payment.</p>
        </div>
    </div>
</div>

<?php
include __DIR__ . '/footer.php';